/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.implementation.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.inventory.IInventoryService;
import org.opendaylight.controller.sal.inventory.IListenInventoryUpdates;
import org.opendaylight.controller.sal.inventory.IPluginInInventoryService;
import org.opendaylight.controller.sal.inventory.IPluginOutInventoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Inventory
implements IPluginOutInventoryService,
IInventoryService {
    protected static final Logger logger = LoggerFactory.getLogger(Inventory.class);
    private List<IListenInventoryUpdates> updateService = new CopyOnWriteArrayList<IListenInventoryUpdates>();
    private List<IPluginInInventoryService> pluginService = new CopyOnWriteArrayList<IPluginInInventoryService>();

    void init() {
        logger.trace("INIT called!");
    }

    void destroy() {
        logger.trace("DESTROY called!");
    }

    void start() {
        logger.trace("START called!");
        if (this.pluginService == null) {
            logger.debug("plugin service not avaiable");
            return;
        }
    }

    void stop() {
        logger.trace("STOP called!");
    }

    public void setPluginService(IPluginInInventoryService service) {
        logger.trace("Got plugin service set request {}", (Object)service);
        this.pluginService.add(service);
    }

    public void unsetPluginService(IPluginInInventoryService service) {
        logger.trace("Got plugin service UNset request");
        this.pluginService.remove(service);
    }

    public void setUpdateService(IListenInventoryUpdates service) {
        logger.trace("Got update service set request {}", (Object)service);
        this.updateService.add(service);
    }

    public void unsetUpdateService(IListenInventoryUpdates service) {
        logger.trace("Got a service UNset request");
        this.updateService.remove(service);
    }

    public void updateNode(Node node, UpdateType type, Set<Property> props) {
        if (type == null) {
            logger.trace("Input type is null");
            return;
        }
        logger.trace("{} {}", (Object)node, (Object)type);
        for (IListenInventoryUpdates s : this.updateService) {
            s.updateNode(node, type, props);
        }
    }

    public void updateNodeConnector(NodeConnector nodeConnector, UpdateType type, Set<Property> props) {
        if (type == null) {
            logger.trace("Input type is null");
            return;
        }
        logger.trace("{} {}", (Object)nodeConnector, (Object)type);
        for (IListenInventoryUpdates s : this.updateService) {
            s.updateNodeConnector(nodeConnector, type, props);
        }
    }

    public ConcurrentMap<Node, Map<String, Property>> getNodeProps() {
        ConcurrentHashMap<Node, Map<String, Property>> nodeProps = new ConcurrentHashMap<Node, Map<String, Property>>();
        for (IPluginInInventoryService s : this.pluginService) {
            ConcurrentMap rv = s.getNodeProps();
            if (rv == null) continue;
            nodeProps.putAll(rv);
        }
        return nodeProps;
    }

    public Set<Node> getConfiguredNotConnectedNodes() {
        HashSet<Node> configuredNotConnected = new HashSet<Node>();
        for (IPluginInInventoryService s : this.pluginService) {
            Set rv = s.getConfiguredNotConnectedNodes();
            if (rv == null) continue;
            configuredNotConnected.addAll(rv);
        }
        return configuredNotConnected;
    }

    public ConcurrentMap<NodeConnector, Map<String, Property>> getNodeConnectorProps() {
        ConcurrentHashMap<NodeConnector, Map<String, Property>> ncProps = new ConcurrentHashMap<NodeConnector, Map<String, Property>>();
        for (IPluginInInventoryService s : this.pluginService) {
            ConcurrentMap rv = s.getNodeConnectorProps(Boolean.valueOf(true));
            if (rv == null) continue;
            ncProps.putAll(rv);
        }
        return ncProps;
    }
}

