/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.implementation.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.implementation.internal.ProtocolService;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.packet.Ethernet;
import org.opendaylight.controller.sal.packet.IDataPacketService;
import org.opendaylight.controller.sal.packet.IListenDataPacket;
import org.opendaylight.controller.sal.packet.IPluginInDataPacketService;
import org.opendaylight.controller.sal.packet.IPluginOutDataPacketService;
import org.opendaylight.controller.sal.packet.LinkEncap;
import org.opendaylight.controller.sal.packet.Packet;
import org.opendaylight.controller.sal.packet.PacketResult;
import org.opendaylight.controller.sal.packet.RawPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPacketService
implements IPluginOutDataPacketService,
IDataPacketService {
    private int TXMAXQUEUESIZE = 1000;
    protected static final Logger logger = LoggerFactory.getLogger(DataPacketService.class);
    private ConcurrentHashMap<String, ProtocolService<IPluginInDataPacketService>> pluginInDataService = new ConcurrentHashMap();
    private Map<String, AtomicInteger> statistics = new HashMap<String, AtomicInteger>();
    private LinkedBlockingQueue<RawPacket> txQueue = new LinkedBlockingQueue(this.TXMAXQUEUESIZE);
    private Thread txThread = new Thread((Runnable)new TxLoop(), "DataPacketService TX thread");
    private List<List<DataPacketListener>> listenDataPacket = new CopyOnWriteArrayList<List<DataPacketListener>>();
    private Set<DataPacketListener> indexDataPacket = Collections.synchronizedSet(new HashSet());

    private void dispatchPacket(RawPacket pkt) {
        block2: for (List<DataPacketListener> serialListeners : this.listenDataPacket) {
            for (DataPacketListener l : serialListeners) {
                IListenDataPacket s = l == null ? null : l.listener;
                if (s == null) continue;
                try {
                    PacketResult res = s.receiveDataPacket(pkt);
                    this.increaseStat("RXPacketSuccess");
                    if (!res.equals((Object)PacketResult.CONSUME)) continue;
                    this.increaseStat("RXPacketSerialExit");
                    continue block2;
                }
                catch (Exception e) {
                    this.increaseStat("RXPacketFailedForException");
                }
            }
        }
    }

    void setPluginInDataService(Map props, IPluginInDataPacketService s) {
        ProtocolService.set(this.pluginInDataService, props, s, logger);
    }

    void unsetPluginInDataService(Map props, IPluginInDataPacketService s) {
        ProtocolService.unset(this.pluginInDataService, props, s, logger);
    }

    void setListenDataPacket(Map props, IListenDataPacket s) {
        if (this.listenDataPacket == null || this.indexDataPacket == null) {
            logger.error("data structure to store data is NULL");
            return;
        }
        logger.trace("Received setListenDataPacket request");
        Iterator i$ = props.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry e;
            Map.Entry entry = e = i$.next();
            logger.trace("Prop key:({}) value:({})", entry.getKey(), entry.getValue());
        }
        String listenerName = null;
        String listenerDependency = null;
        Match filter = null;
        Object value = props.get("salListenerName");
        if (value instanceof String) {
            listenerName = (String)value;
        }
        if (listenerName == null) {
            logger.error("Trying to set a listener without a Name");
            return;
        }
        value = props.get("salListenerDependency");
        if (value instanceof String) {
            listenerDependency = (String)value;
        }
        if ((value = props.get("salListenerFilter")) instanceof Match) {
            filter = (Match)value;
        }
        DataPacketListener l = new DataPacketListener(listenerName, s, listenerDependency, filter);
        DataPacketListener lDependency = new DataPacketListener(listenerDependency, null, null, null);
        if (listenerDependency == null) {
            logger.debug("listener without any dependency");
            if (this.indexDataPacket.contains(l)) {
                logger.error("trying to add an existing element");
            } else {
                logger.debug("adding listener: {}", (Object)listenerName);
                CopyOnWriteArrayList<DataPacketListener> serialListeners = new CopyOnWriteArrayList<DataPacketListener>();
                serialListeners.add(l);
                this.listenDataPacket.add(serialListeners);
                this.indexDataPacket.add(l);
            }
        } else {
            logger.debug("listener with dependency");
            if (this.indexDataPacket.contains(l)) {
                logger.error("trying to add an existing element");
            } else {
                logger.debug("adding listener: {}", (Object)listenerName);
                for (List<DataPacketListener> serialListeners : this.listenDataPacket) {
                    boolean done = false;
                    if (serialListeners.contains(lDependency)) {
                        serialListeners.add(l);
                        done = true;
                    }
                    if (!done) continue;
                    break;
                }
                this.indexDataPacket.add(l);
            }
        }
    }

    void unsetListenDataPacket(Map props, IListenDataPacket s) {
        if (this.listenDataPacket == null || this.indexDataPacket == null) {
            logger.error("data structure to store data is NULL");
            return;
        }
        logger.trace("Received UNsetListenDataPacket request");
        Iterator i$ = props.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry e;
            Map.Entry entry = e = i$.next();
            logger.trace("Prop key:({}) value:({})", entry.getKey(), entry.getValue());
        }
        String listenerName = null;
        Object value = props.get("salListenerName");
        if (value instanceof String) {
            listenerName = (String)value;
        }
        if (listenerName == null) {
            logger.error("Trying to set a listener without a Name");
            return;
        }
        DataPacketListener l = new DataPacketListener(listenerName, s, null, null);
        if (!this.indexDataPacket.contains(l)) {
            logger.error("trying to remove a non-existing element");
        } else {
            logger.debug("removing listener: {}", (Object)listenerName);
            for (List<DataPacketListener> serialListeners : this.listenDataPacket) {
                int i = 0;
                boolean done = false;
                for (i = 0; i < serialListeners.size(); ++i) {
                    if (!serialListeners.get(i).equals(l)) continue;
                    serialListeners.remove(i);
                    done = true;
                    break;
                }
                if (serialListeners.isEmpty()) {
                    this.listenDataPacket.remove(serialListeners);
                }
                if (!done) continue;
                break;
            }
            this.indexDataPacket.remove(l);
        }
    }

    void init() {
        this.txThread.start();
    }

    void destroy() {
        this.listenDataPacket.clear();
        this.indexDataPacket.clear();
        this.pluginInDataService.clear();
        this.statistics.clear();
        this.txQueue.clear();
        this.txThread.interrupt();
        try {
            this.txThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseStat(String name) {
        if (this.statistics == null) {
            return;
        }
        AtomicInteger currValue = null;
        Map<String, AtomicInteger> map = this.statistics;
        synchronized (map) {
            currValue = this.statistics.get(name);
            if (currValue == null) {
                this.statistics.put(name, new AtomicInteger(0));
                return;
            }
        }
        currValue.incrementAndGet();
    }

    public PacketResult receiveDataPacket(RawPacket inPkt) {
        if (inPkt.getIncomingNodeConnector() == null) {
            this.increaseStat("nullIncomingNodeConnector");
            return PacketResult.IGNORED;
        }
        this.dispatchPacket(inPkt);
        return PacketResult.IGNORED;
    }

    public void transmitDataPacket(RawPacket outPkt) {
        if (outPkt.getOutgoingNodeConnector() == null) {
            this.increaseStat("nullOutgoingNodeConnector");
            return;
        }
        if (!this.txQueue.offer(outPkt)) {
            this.increaseStat("fullTXQueue");
            return;
        }
    }

    public Packet decodeDataPacket(RawPacket pkt) {
        if (pkt == null) {
            return null;
        }
        byte[] data = pkt.getPacketData();
        if (data.length <= 0) {
            return null;
        }
        if (pkt.getEncap().equals((Object)LinkEncap.ETHERNET)) {
            Ethernet res = new Ethernet();
            try {
                res.deserialize(data, 0, data.length * 8);
            }
            catch (Exception e) {
                logger.warn("Failed to decode packet: {}", (Object)e.getMessage());
            }
            return res;
        }
        return null;
    }

    public RawPacket encodeDataPacket(Packet pkt) {
        byte[] data;
        if (pkt == null) {
            return null;
        }
        try {
            data = pkt.serialize();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
        if (data.length <= 0) {
            return null;
        }
        try {
            RawPacket res = new RawPacket(data);
            return res;
        }
        catch (ConstructionException constructionException) {
            return null;
        }
    }

    private class TxLoop
    implements Runnable {
        private TxLoop() {
        }

        @Override
        public void run() {
            try {
                RawPacket pkt = (RawPacket)DataPacketService.this.txQueue.take();
                while (pkt != null) {
                    NodeConnector p = pkt.getOutgoingNodeConnector();
                    if (p != null) {
                        String t = p.getNode().getType();
                        ProtocolService service = (ProtocolService)DataPacketService.this.pluginInDataService.get(t);
                        if (service != null) {
                            try {
                                ((IPluginInDataPacketService)service.getService()).transmitDataPacket(pkt);
                                DataPacketService.this.increaseStat("TXPacketSuccess");
                            }
                            catch (Exception e) {
                                DataPacketService.this.increaseStat("TXPacketFailedForException");
                            }
                        } else {
                            DataPacketService.this.increaseStat("TXpluginNotFound");
                        }
                    }
                    pkt = (RawPacket)DataPacketService.this.txQueue.take();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class DataPacketListener {
        private String listenerName;
        private IListenDataPacket listener;
        private String dependency;
        private Match match;

        DataPacketListener(String name, IListenDataPacket s, String dependency, Match match) {
            this.listenerName = name;
            this.listener = s;
            this.dependency = dependency;
            this.match = match;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DataPacketListener other = (DataPacketListener)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.listenerName == null ? other.listenerName != null : !this.listenerName.equals(other.listenerName));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.listenerName == null ? 0 : this.listenerName.hashCode());
            return result;
        }

        private DataPacketService getOuterType() {
            return DataPacketService.this;
        }
    }
}

