/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.restconf.broker.tools;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.CreateNotificationStreamInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.CreateNotificationStreamOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.SalRemoteService;
import org.opendaylight.yangtools.restconf.client.api.RestconfClientContext;
import org.opendaylight.yangtools.restconf.client.api.event.EventStreamInfo;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteStreamTools {
    private static final Logger logger = LoggerFactory.getLogger((String)RemoteStreamTools.class.toString());

    public static String createNotificationStream(SalRemoteService salRemoteService, List<QName> notifications) {
        CreateNotificationStreamInputBuilder notificationStreamInputBuilder = new CreateNotificationStreamInputBuilder();
        if (null == notifications) {
            notificationStreamInputBuilder.setNotifications(notifications);
        }
        Future notificationStream = salRemoteService.createNotificationStream(notificationStreamInputBuilder.build());
        String nofiticationStreamIdentifier = "";
        try {
            if (((RpcResult)notificationStream.get()).isSuccessful()) {
                nofiticationStreamIdentifier = ((CreateNotificationStreamOutput)((RpcResult)notificationStream.get()).getResult()).getNotificationStreamIdentifier();
            }
        }
        catch (InterruptedException e) {
            logger.trace("Interrupted while resolving notification stream identifier due to {}", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.trace("Execution exception while resolving notification stream identifier due to {}", (Throwable)e);
        }
        return nofiticationStreamIdentifier;
    }

    public static Map<String, EventStreamInfo> createEventStream(RestconfClientContext restconfClientContext, String desiredStreamName) {
        ListenableFuture availableEventStreams = restconfClientContext.getAvailableEventStreams();
        HashMap<String, EventStreamInfo> desiredEventStream = new HashMap<String, EventStreamInfo>();
        try {
            Iterator it = ((Set)availableEventStreams.get()).iterator();
            while (it.hasNext()) {
                if (!((EventStreamInfo)it.next()).getIdentifier().equals(desiredStreamName)) continue;
                desiredEventStream.put(desiredStreamName, (EventStreamInfo)it.next());
            }
        }
        catch (InterruptedException e) {
            logger.trace("Resolving of event stream interrupted due to  {}", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.trace("Resolving of event stream failed due to {}", (Throwable)e);
        }
        return desiredEventStream;
    }
}

