/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.restconf.broker.impl;

import java.util.ArrayList;
import java.util.Map;
import org.opendaylight.controller.sal.binding.api.NotificationListener;
import org.opendaylight.controller.sal.binding.api.NotificationService;
import org.opendaylight.controller.sal.restconf.broker.listeners.RemoteNotificationListener;
import org.opendaylight.controller.sal.restconf.broker.tools.RemoteStreamTools;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.SalRemoteService;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.restconf.client.api.RestconfClientContext;
import org.opendaylight.yangtools.restconf.client.api.event.EventStreamInfo;
import org.opendaylight.yangtools.yang.binding.Notification;

public class NotificationServiceImpl
implements NotificationService {
    private final SalRemoteService salRemoteService;
    private final RestconfClientContext restconfClientContext;

    public NotificationServiceImpl(RestconfClientContext restconfClienetContext) {
        this.restconfClientContext = restconfClienetContext;
        this.salRemoteService = (SalRemoteService)this.restconfClientContext.getRpcServiceContext(SalRemoteService.class).getRpcService();
    }

    public <T extends Notification> ListenerRegistration<NotificationListener<T>> registerNotificationListener(Class<T> notificationType, NotificationListener<T> listener) {
        ArrayList<QName> notifications = new ArrayList<QName>();
        notifications.add(new QName(notificationType.toString()));
        String notificationStreamName = RemoteStreamTools.createNotificationStream(this.salRemoteService, notifications);
        Map<String, EventStreamInfo> desiredEventStream = RemoteStreamTools.createEventStream(this.restconfClientContext, notificationStreamName);
        RemoteNotificationListener<T> remoteNotificationListener = new RemoteNotificationListener<T>(listener);
        final ListenerRegistration listenerRegistration = this.restconfClientContext.getEventStreamContext(desiredEventStream.get(desiredEventStream.get(notificationStreamName))).registerNotificationListener(remoteNotificationListener);
        return new AbstractListenerRegistration<NotificationListener<T>>(listener){

            protected void removeRegistration() {
                listenerRegistration.close();
            }
        };
    }

    public ListenerRegistration<org.opendaylight.yangtools.yang.binding.NotificationListener> registerNotificationListener(org.opendaylight.yangtools.yang.binding.NotificationListener listener) {
        String notificationStreamName = RemoteStreamTools.createNotificationStream(this.salRemoteService, null);
        Map<String, EventStreamInfo> desiredEventStream = RemoteStreamTools.createEventStream(this.restconfClientContext, notificationStreamName);
        return this.restconfClientContext.getEventStreamContext(desiredEventStream.get(desiredEventStream.get(notificationStreamName))).registerNotificationListener(listener);
    }
}

