/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.restconf.broker.impl;

import com.google.common.base.Optional;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.opendaylight.controller.sal.binding.api.data.DataBrokerService;
import org.opendaylight.controller.sal.binding.api.data.DataChangeListener;
import org.opendaylight.controller.sal.binding.api.data.DataModificationTransaction;
import org.opendaylight.controller.sal.restconf.broker.listeners.RemoteDataChangeNotificationListener;
import org.opendaylight.controller.sal.restconf.broker.tools.RemoteStreamTools;
import org.opendaylight.controller.sal.restconf.broker.transactions.RemoteDataModificationTransaction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.CreateDataChangeEventSubscriptionInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.CreateDataChangeEventSubscriptionOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.SalRemoteService;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.restconf.client.api.RestconfClientContext;
import org.opendaylight.yangtools.restconf.client.api.event.EventStreamInfo;
import org.opendaylight.yangtools.restconf.client.api.event.ListenableEventStreamContext;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBrokerServiceImpl
implements DataBrokerService {
    private static final Logger logger = LoggerFactory.getLogger((String)DataBrokerServiceImpl.class.toString());
    private final RestconfClientContext restconfClientContext;
    private final SalRemoteService salRemoteService;

    public DataBrokerServiceImpl(RestconfClientContext restconfClientContext) {
        this.restconfClientContext = restconfClientContext;
        this.salRemoteService = (SalRemoteService)this.restconfClientContext.getRpcServiceContext(SalRemoteService.class).getRpcService();
    }

    public DataModificationTransaction beginTransaction() {
        Future rpcResultFuture = this.salRemoteService.beginTransaction();
        RemoteDataModificationTransaction remoteDataModificationTransaction = new RemoteDataModificationTransaction();
        return remoteDataModificationTransaction;
    }

    public DataObject readConfigurationData(InstanceIdentifier<? extends DataObject> path) {
        try {
            Optional optDataObject = (Optional)this.restconfClientContext.getConfigurationDatastore().readData(path).get();
            if (optDataObject.isPresent()) {
                return (DataObject)optDataObject.get();
            }
        }
        catch (InterruptedException e) {
            logger.trace("Reading configuration data interrupted {}", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.trace("Reading configuration execution exception {}", (Throwable)e);
        }
        throw new IllegalStateException("No data to return.");
    }

    public DataObject readOperationalData(InstanceIdentifier<? extends DataObject> path) {
        try {
            Optional optDataObject = (Optional)this.restconfClientContext.getOperationalDatastore().readData(path).get();
            if (optDataObject.isPresent()) {
                return (DataObject)optDataObject.get();
            }
        }
        catch (InterruptedException e) {
            logger.trace("Reading configuration data interrupted {}", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.trace("Reading configuration execution exception {}", (Throwable)e);
        }
        throw new IllegalStateException("No data to return.");
    }

    public ListenerRegistration<DataChangeListener> registerDataChangeListener(InstanceIdentifier<? extends DataObject> path, DataChangeListener listener) {
        CreateDataChangeEventSubscriptionInputBuilder inputBuilder = new CreateDataChangeEventSubscriptionInputBuilder();
        Future rpcResultFuture = this.salRemoteService.createDataChangeEventSubscription(inputBuilder.setPath(path).build());
        String streamName = "";
        try {
            if (((RpcResult)rpcResultFuture.get()).isSuccessful()) {
                streamName = ((CreateDataChangeEventSubscriptionOutput)((RpcResult)rpcResultFuture.get()).getResult()).getStreamName();
            }
        }
        catch (InterruptedException e) {
            logger.trace("Interupted while getting rpc result due to {}", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.trace("Execution exception while getting rpc result due to {}", (Throwable)e);
        }
        Map<String, EventStreamInfo> desiredEventStream = RemoteStreamTools.createEventStream(this.restconfClientContext, streamName);
        ListenableEventStreamContext restConfListenableEventStreamContext = this.restconfClientContext.getEventStreamContext(desiredEventStream.get(streamName));
        RemoteDataChangeNotificationListener remoteDataChangeNotificationListener = new RemoteDataChangeNotificationListener(listener);
        final ListenerRegistration reg = restConfListenableEventStreamContext.registerNotificationListener((NotificationListener)remoteDataChangeNotificationListener);
        return new AbstractListenerRegistration<DataChangeListener>(listener){

            protected void removeRegistration() {
                reg.close();
            }
        };
    }
}

