/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.restconf.broker.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.controller.md.sal.common.api.data.DataChangeEvent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.DataChangedNotification;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

@ThreadSafe
public class RemoteDataChangeEvent
implements DataChangeEvent<InstanceIdentifier<? extends DataObject>, DataObject> {
    private final Map<InstanceIdentifier<?>, DataObject> createdConfig;
    private final Map<InstanceIdentifier<?>, DataObject> createdOper;
    private final Map<InstanceIdentifier<?>, DataObject> origConfig;
    private final Map<InstanceIdentifier<?>, DataObject> origOper;
    private final Map<InstanceIdentifier<?>, DataObject> updatedConfig;
    private final Map<InstanceIdentifier<?>, DataObject> updatedOper;
    private final Set<InstanceIdentifier<?>> removedConfig;
    private final Set<InstanceIdentifier<?>> removedOper;

    public RemoteDataChangeEvent(DataChangedNotification dataChangedNotification) {
        HashMap<InstanceIdentifier, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent> createdConfig = new HashMap<InstanceIdentifier, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent>();
        HashMap<InstanceIdentifier, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent> createdOper = new HashMap<InstanceIdentifier, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent>();
        HashMap<InstanceIdentifier, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent> origConfig = new HashMap<InstanceIdentifier, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent>();
        HashMap<InstanceIdentifier, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent> origOper = new HashMap<InstanceIdentifier, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent>();
        HashMap<InstanceIdentifier, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent> updatedConfig = new HashMap<InstanceIdentifier, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent>();
        HashMap<InstanceIdentifier, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent> updatedOper = new HashMap<InstanceIdentifier, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent>();
        HashSet<InstanceIdentifier> removedConfig = new HashSet<InstanceIdentifier>();
        HashSet<InstanceIdentifier> removedOper = new HashSet<InstanceIdentifier>();
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent d : dataChangedNotification.getDataChangeEvent()) {
            block0 : switch (d.getOperation()) {
                case Created: {
                    switch (d.getStore()) {
                        case Config: {
                            createdConfig.put(d.getPath(), d);
                            break block0;
                        }
                        case Operation: {
                            createdOper.put(d.getPath(), d);
                        }
                    }
                    break;
                }
                case Deleted: {
                    switch (d.getStore()) {
                        case Config: {
                            removedConfig.add(d.getPath());
                            break block0;
                        }
                        case Operation: {
                            removedOper.add(d.getPath());
                        }
                    }
                    break;
                }
                case Updated: {
                    switch (d.getStore()) {
                        case Config: {
                            origConfig.put(d.getPath(), d);
                            updatedConfig.put(d.getPath(), d);
                            break block0;
                        }
                        case Operation: {
                            origOper.put(d.getPath(), d);
                            updatedOper.put(d.getPath(), d);
                        }
                    }
                }
            }
        }
        this.createdConfig = Collections.unmodifiableMap(createdConfig);
        this.createdOper = Collections.unmodifiableMap(createdOper);
        this.origConfig = Collections.unmodifiableMap(origConfig);
        this.origOper = Collections.unmodifiableMap(origOper);
        this.updatedConfig = Collections.unmodifiableMap(updatedConfig);
        this.updatedOper = Collections.unmodifiableMap(updatedOper);
        this.removedConfig = Collections.unmodifiableSet(removedConfig);
        this.removedOper = Collections.unmodifiableSet(removedOper);
    }

    public DataObject getOriginalConfigurationSubtree() {
        throw new UnsupportedOperationException();
    }

    public DataObject getOriginalOperationalSubtree() {
        throw new UnsupportedOperationException();
    }

    public DataObject getUpdatedConfigurationSubtree() {
        throw new UnsupportedOperationException();
    }

    public DataObject getUpdatedOperationalSubtree() {
        throw new UnsupportedOperationException();
    }

    public Map<InstanceIdentifier<?>, DataObject> getCreatedOperationalData() {
        return this.createdOper;
    }

    public Map<InstanceIdentifier<?>, DataObject> getCreatedConfigurationData() {
        return this.createdConfig;
    }

    public Map<InstanceIdentifier<?>, DataObject> getUpdatedOperationalData() {
        return this.updatedOper;
    }

    public Map<InstanceIdentifier<?>, DataObject> getUpdatedConfigurationData() {
        return this.updatedConfig;
    }

    public Set<InstanceIdentifier<?>> getRemovedConfigurationData() {
        return this.removedConfig;
    }

    public Set<InstanceIdentifier<?>> getRemovedOperationalData() {
        return this.removedOper;
    }

    public Map<InstanceIdentifier<?>, DataObject> getOriginalConfigurationData() {
        return this.origConfig;
    }

    public Map<InstanceIdentifier<?>, DataObject> getOriginalOperationalData() {
        return this.origOper;
    }
}

