/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.restconf.broker.client;

import com.google.common.base.Preconditions;
import java.net.URL;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareConsumer;
import org.opendaylight.controller.sal.restconf.broker.SalRemoteServiceBroker;
import org.opendaylight.controller.sal.restconf.broker.client.SalRemoteClient;
import org.opendaylight.yangtools.restconf.client.RestconfClientFactory;
import org.opendaylight.yangtools.restconf.client.api.RestconfClientContext;
import org.opendaylight.yangtools.restconf.client.api.UnsupportedProtocolException;
import org.opendaylight.yangtools.sal.binding.generator.impl.ModuleInfoBackedContext;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SalRemoteClientImpl
implements SalRemoteClient,
SchemaContextHolder {
    private static final Logger logger = LoggerFactory.getLogger(SalRemoteClientImpl.class);
    private final RestconfClientContext restconfClientContext;
    private final SalRemoteServiceBroker salRemoteBroker;
    private SchemaContext schemaContext;

    public SalRemoteClientImpl(URL url) {
        Preconditions.checkNotNull((Object)url);
        ModuleInfoBackedContext moduleInfo = ModuleInfoBackedContext.create();
        moduleInfo.addModuleInfos((Iterable)BindingReflections.loadModuleInfos());
        this.schemaContext = (SchemaContext)moduleInfo.tryToCreateSchemaContext().get();
        try {
            this.restconfClientContext = new RestconfClientFactory().getRestconfClientContext(url, (SchemaContextHolder)this);
            this.salRemoteBroker = new SalRemoteServiceBroker("remote-broker", this.restconfClientContext);
            this.salRemoteBroker.start();
        }
        catch (UnsupportedProtocolException e) {
            logger.error("Unsupported protocol {}.", (Object)url.getProtocol(), (Object)e);
            throw new IllegalArgumentException("Unsupported protocol.", e);
        }
    }

    @Override
    public BindingAwareBroker.ConsumerContext registerConsumer() {
        return this.salRemoteBroker.registerConsumer(new BindingAwareConsumer(){

            public void onSessionInitialized(BindingAwareBroker.ConsumerContext session) {
            }
        }, null);
    }

    public SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    @Override
    public void close() throws Exception {
        this.restconfClientContext.close();
        this.salRemoteBroker.close();
    }
}

