/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.restconf.broker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableClassToInstanceMap;
import org.opendaylight.controller.md.sal.binding.util.BindingContextUtils;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareConsumer;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.opendaylight.controller.sal.binding.api.BindingAwareService;
import org.opendaylight.controller.sal.binding.api.NotificationService;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.controller.sal.binding.api.data.DataBrokerService;
import org.opendaylight.controller.sal.restconf.broker.impl.RemoteServicesFactory;
import org.opendaylight.yangtools.restconf.client.api.RestconfClientContext;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalRemoteServiceBroker
implements BindingAwareBroker,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger((String)SalRemoteServiceBroker.class.toString());
    private ImmutableClassToInstanceMap<BindingAwareService> supportedConsumerServices;
    private final String identifier;
    private RpcConsumerRegistry rpcBroker;
    private NotificationService notificationBroker;
    private DataBrokerService dataBroker;
    private final RemoteServicesFactory servicesFactory;

    public SalRemoteServiceBroker(String instanceName, RestconfClientContext clientContext) {
        this.identifier = instanceName;
        this.servicesFactory = new RemoteServicesFactory(clientContext);
    }

    public void start() {
        logger.info("Starting Binding Aware Broker: {}", (Object)this.identifier);
        this.supportedConsumerServices = ImmutableClassToInstanceMap.builder().put(NotificationService.class, (Object)this.servicesFactory.getNotificationService()).put(DataBrokerService.class, (Object)this.servicesFactory.getDataBrokerService()).put(RpcConsumerRegistry.class, (Object)this.servicesFactory.getRpcConsumerRegistry()).build();
    }

    public BindingAwareBroker.ProviderContext registerProvider(BindingAwareProvider provider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
    }

    public BindingAwareBroker.ConsumerContext registerConsumer(BindingAwareConsumer consumer) {
        Preconditions.checkState((this.supportedConsumerServices != null ? 1 : 0) != 0, (Object)"Broker is not initialized.");
        return BindingContextUtils.createConsumerContextAndInitialize((BindingAwareConsumer)consumer, this.supportedConsumerServices);
    }

    public BindingAwareBroker.ConsumerContext registerConsumer(BindingAwareConsumer consumer, BundleContext ctx) {
        return this.registerConsumer(consumer);
    }

    public BindingAwareBroker.ProviderContext registerProvider(BindingAwareProvider provider, BundleContext ctx) {
        return this.registerProvider(provider);
    }
}

