/*
 * Copyright (c) 2014 Cisco Systems, Inc. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */
/**
 * Generated file

 * Generated from: yang module name: opendaylight-sal-binding-broker-impl  yang module local name: binding-broker-impl
 * Generated by: org.opendaylight.controller.config.yangjmxgenerator.plugin.JMXGenerator
 * Generated at: Wed Nov 20 17:33:01 CET 2013
 *
 * Do not modify this file unless it is present under src/main directory
 */
package org.opendaylight.controller.config.yang.md.sal.binding.impl;

import org.opendaylight.controller.md.sal.binding.api.MountPointService;
import org.opendaylight.controller.md.sal.binding.compat.HeliumRpcProviderRegistry;
import org.opendaylight.controller.md.sal.binding.compat.HydrogenMountProvisionServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMMountPointServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMRpcProviderServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMRpcServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPointService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcProviderService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.controller.sal.binding.api.mount.MountProviderService;
import org.opendaylight.controller.sal.binding.impl.RootBindingAwareBroker;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.Broker.ProviderSession;

/**
*
*/
public final class BindingBrokerImplModule extends
        org.opendaylight.controller.config.yang.md.sal.binding.impl.AbstractBindingBrokerImplModule {

    public BindingBrokerImplModule(final org.opendaylight.controller.config.api.ModuleIdentifier identifier,
            final org.opendaylight.controller.config.api.DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public BindingBrokerImplModule(final org.opendaylight.controller.config.api.ModuleIdentifier identifier,
            final org.opendaylight.controller.config.api.DependencyResolver dependencyResolver,
            final BindingBrokerImplModule oldModule, final java.lang.AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public RootBindingAwareBroker createInstance() {
        final Broker domBroker = getDomAsyncBrokerDependency();
        final BindingToNormalizedNodeCodec codec = getBindingMappingServiceDependency();
        final ProviderSession session = domBroker.registerProvider(new DummyDOMProvider());

        final MountPointService mount = createMountPointAdapter(codec,session);
        final BindingDOMRpcServiceAdapter rpcConsumer = createRpcConsumer(codec,session);
        final BindingDOMRpcProviderServiceAdapter rpcProvider = createRpcProvider(codec,session);
        final RootBindingAwareBroker broker = new RootBindingAwareBroker(getIdentifier().getInstanceName());
        final RpcProviderRegistry heliumRpcBroker = new HeliumRpcProviderRegistry(rpcConsumer, rpcProvider);
        final MountProviderService legacyMount = createLegacyMountPointService(mount);


        broker.setLegacyDataBroker(getDataBrokerDependency());
        broker.setNotificationBroker(getNotificationServiceDependency());
        if (getNotificationPublishServiceDependency() != null) {
            broker.setNotificationPublishService(getNotificationPublishServiceDependency());
        }
        broker.setRpcBroker(heliumRpcBroker);
        broker.setDataBroker(getRootDataBrokerDependency());
        broker.setMountService(mount);
        broker.setLegacyMountManager(legacyMount);
        broker.start();
        return broker;
    }


    @SuppressWarnings("deprecation")
    private MountProviderService createLegacyMountPointService(final MountPointService service) {
        if(service != null) {
            return new HydrogenMountProvisionServiceAdapter(service);
        }
        return null;
    }

    private BindingDOMRpcProviderServiceAdapter createRpcProvider(final BindingToNormalizedNodeCodec codec,
            final ProviderSession session) {
        final DOMRpcProviderService domService = session.getService(DOMRpcProviderService.class);
        if(domService != null) {
            return new BindingDOMRpcProviderServiceAdapter(domService, codec);
        }
        return null;
    }

    private BindingDOMRpcServiceAdapter createRpcConsumer(final BindingToNormalizedNodeCodec codec, final ProviderSession session) {
        final DOMRpcService domService = session.getService(DOMRpcService.class);
        if(domService != null) {
            return new BindingDOMRpcServiceAdapter(domService, codec);
        }
        return null;
    }

    private MountPointService createMountPointAdapter(final BindingToNormalizedNodeCodec codec, final ProviderSession session) {
        final DOMMountPointService domService = session.getService(DOMMountPointService.class);
        if(domService != null) {
            return new BindingDOMMountPointServiceAdapter(domService, codec);
        }
        return null;
    }

}
