/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.api;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public final class DataTreeIdentifier<T extends DataObject>
implements Immutable,
Path<DataTreeIdentifier<?>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final InstanceIdentifier<T> rootIdentifier;
    private final LogicalDatastoreType datastoreType;

    public DataTreeIdentifier(LogicalDatastoreType datastoreType, InstanceIdentifier<T> rootIdentifier) {
        this.datastoreType = (LogicalDatastoreType)Preconditions.checkNotNull((Object)datastoreType);
        this.rootIdentifier = (InstanceIdentifier)Preconditions.checkNotNull(rootIdentifier);
    }

    @Nonnull
    public LogicalDatastoreType getDatastoreType() {
        return this.datastoreType;
    }

    @Nonnull
    public InstanceIdentifier<T> getRootIdentifier() {
        return this.rootIdentifier;
    }

    public boolean contains(DataTreeIdentifier<?> other) {
        return this.datastoreType == other.datastoreType && this.rootIdentifier.contains(other.rootIdentifier);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.datastoreType.hashCode();
        result = 31 * result + this.rootIdentifier.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataTreeIdentifier)) {
            return false;
        }
        DataTreeIdentifier other = (DataTreeIdentifier)obj;
        if (this.datastoreType != other.datastoreType) {
            return false;
        }
        return this.rootIdentifier.equals(other.rootIdentifier);
    }
}

