package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.timed.reconnect.strategy.factory.TimedReconnectExecutor;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;
import java.math.BigDecimal;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory
 *
 */
public class TimedReconnectStrategyFactoryBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory> {

    private java.lang.Integer _connectTime;
    private java.lang.Long _deadline;
    private java.lang.Long _maxAttempts;
    private java.lang.Long _maxSleep;
    private java.lang.Long _minSleep;
    private BigDecimal _sleepFactor;
    private TimedReconnectExecutor _timedReconnectExecutor;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>> augmentation = Collections.emptyMap();

    public TimedReconnectStrategyFactoryBuilder() {
    }

    public TimedReconnectStrategyFactoryBuilder(TimedReconnectStrategyFactory base) {
        this._connectTime = base.getConnectTime();
        this._deadline = base.getDeadline();
        this._maxAttempts = base.getMaxAttempts();
        this._maxSleep = base.getMaxSleep();
        this._minSleep = base.getMinSleep();
        this._sleepFactor = base.getSleepFactor();
        this._timedReconnectExecutor = base.getTimedReconnectExecutor();
        if (base instanceof TimedReconnectStrategyFactoryImpl) {
            TimedReconnectStrategyFactoryImpl impl = (TimedReconnectStrategyFactoryImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.Integer getConnectTime() {
        return _connectTime;
    }
    
    public java.lang.Long getDeadline() {
        return _deadline;
    }
    
    public java.lang.Long getMaxAttempts() {
        return _maxAttempts;
    }
    
    public java.lang.Long getMaxSleep() {
        return _maxSleep;
    }
    
    public java.lang.Long getMinSleep() {
        return _minSleep;
    }
    
    public BigDecimal getSleepFactor() {
        return _sleepFactor;
    }
    
    public TimedReconnectExecutor getTimedReconnectExecutor() {
        return _timedReconnectExecutor;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public TimedReconnectStrategyFactoryBuilder setConnectTime(final java.lang.Integer value) {
        this._connectTime = value;
        return this;
    }
    
     
    public TimedReconnectStrategyFactoryBuilder setDeadline(final java.lang.Long value) {
        this._deadline = value;
        return this;
    }
    
     
    public TimedReconnectStrategyFactoryBuilder setMaxAttempts(final java.lang.Long value) {
        this._maxAttempts = value;
        return this;
    }
    
     
    public TimedReconnectStrategyFactoryBuilder setMaxSleep(final java.lang.Long value) {
        this._maxSleep = value;
        return this;
    }
    
     
    public TimedReconnectStrategyFactoryBuilder setMinSleep(final java.lang.Long value) {
        this._minSleep = value;
        return this;
    }
    
     
    public TimedReconnectStrategyFactoryBuilder setSleepFactor(final BigDecimal value) {
        this._sleepFactor = value;
        return this;
    }
    
     
    public TimedReconnectStrategyFactoryBuilder setTimedReconnectExecutor(final TimedReconnectExecutor value) {
        this._timedReconnectExecutor = value;
        return this;
    }
    
    public TimedReconnectStrategyFactoryBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public TimedReconnectStrategyFactoryBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TimedReconnectStrategyFactory build() {
        return new TimedReconnectStrategyFactoryImpl(this);
    }

    private static final class TimedReconnectStrategyFactoryImpl implements TimedReconnectStrategyFactory {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory.class;
        }

        private final java.lang.Integer _connectTime;
        private final java.lang.Long _deadline;
        private final java.lang.Long _maxAttempts;
        private final java.lang.Long _maxSleep;
        private final java.lang.Long _minSleep;
        private final BigDecimal _sleepFactor;
        private final TimedReconnectExecutor _timedReconnectExecutor;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>> augmentation = Collections.emptyMap();

        private TimedReconnectStrategyFactoryImpl(TimedReconnectStrategyFactoryBuilder base) {
            this._connectTime = base.getConnectTime();
            this._deadline = base.getDeadline();
            this._maxAttempts = base.getMaxAttempts();
            this._maxSleep = base.getMaxSleep();
            this._minSleep = base.getMinSleep();
            this._sleepFactor = base.getSleepFactor();
            this._timedReconnectExecutor = base.getTimedReconnectExecutor();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.Integer getConnectTime() {
            return _connectTime;
        }
        
        @Override
        public java.lang.Long getDeadline() {
            return _deadline;
        }
        
        @Override
        public java.lang.Long getMaxAttempts() {
            return _maxAttempts;
        }
        
        @Override
        public java.lang.Long getMaxSleep() {
            return _maxSleep;
        }
        
        @Override
        public java.lang.Long getMinSleep() {
            return _minSleep;
        }
        
        @Override
        public BigDecimal getSleepFactor() {
            return _sleepFactor;
        }
        
        @Override
        public TimedReconnectExecutor getTimedReconnectExecutor() {
            return _timedReconnectExecutor;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_connectTime);
            result = prime * result + Objects.hashCode(_deadline);
            result = prime * result + Objects.hashCode(_maxAttempts);
            result = prime * result + Objects.hashCode(_maxSleep);
            result = prime * result + Objects.hashCode(_minSleep);
            result = prime * result + Objects.hashCode(_sleepFactor);
            result = prime * result + Objects.hashCode(_timedReconnectExecutor);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory)obj;
            if (!Objects.equals(_connectTime, other.getConnectTime())) {
                return false;
            }
            if (!Objects.equals(_deadline, other.getDeadline())) {
                return false;
            }
            if (!Objects.equals(_maxAttempts, other.getMaxAttempts())) {
                return false;
            }
            if (!Objects.equals(_maxSleep, other.getMaxSleep())) {
                return false;
            }
            if (!Objects.equals(_minSleep, other.getMinSleep())) {
                return false;
            }
            if (!Objects.equals(_sleepFactor, other.getSleepFactor())) {
                return false;
            }
            if (!Objects.equals(_timedReconnectExecutor, other.getTimedReconnectExecutor())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                TimedReconnectStrategyFactoryImpl otherImpl = (TimedReconnectStrategyFactoryImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.protocol.framework.rev140313.modules.module.configuration.TimedReconnectStrategyFactory>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "TimedReconnectStrategyFactory [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_connectTime != null) {
                builder.append("_connectTime=");
                builder.append(_connectTime);
                builder.append(", ");
            }
            if (_deadline != null) {
                builder.append("_deadline=");
                builder.append(_deadline);
                builder.append(", ");
            }
            if (_maxAttempts != null) {
                builder.append("_maxAttempts=");
                builder.append(_maxAttempts);
                builder.append(", ");
            }
            if (_maxSleep != null) {
                builder.append("_maxSleep=");
                builder.append(_maxSleep);
                builder.append(", ");
            }
            if (_minSleep != null) {
                builder.append("_minSleep=");
                builder.append(_minSleep);
                builder.append(", ");
            }
            if (_sleepFactor != null) {
                builder.append("_sleepFactor=");
                builder.append(_sleepFactor);
                builder.append(", ");
            }
            if (_timedReconnectExecutor != null) {
                builder.append("_timedReconnectExecutor=");
                builder.append(_timedReconnectExecutor);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
