/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.framework;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.framework.SessionListener;
import org.opendaylight.protocol.framework.SimpleMessage;
import org.opendaylight.protocol.framework.SimpleSession;
import org.opendaylight.protocol.framework.TerminationReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSessionListener
implements SessionListener<SimpleMessage, SimpleSession, TerminationReason> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSessionListener.class);
    public List<SimpleMessage> messages = new ArrayList<SimpleMessage>();
    public boolean up = false;
    public boolean failed = false;

    public void onMessage(SimpleSession session, SimpleMessage message) {
        logger.debug("Received message: " + message.getClass() + " " + message);
        this.messages.add(message);
    }

    public void onSessionUp(SimpleSession session) {
        this.up = true;
    }

    public void onSessionDown(SimpleSession session, Exception e) {
        this.failed = true;
        this.notifyAll();
    }

    public void onSessionTerminated(SimpleSession session, TerminationReason reason) {
        this.failed = true;
        this.notifyAll();
    }
}

