/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.framework;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import org.opendaylight.protocol.framework.AbstractDispatcher;
import org.opendaylight.protocol.framework.ReconnectStrategy;
import org.opendaylight.protocol.framework.ReconnectStrategyFactory;
import org.opendaylight.protocol.framework.SessionListenerFactory;
import org.opendaylight.protocol.framework.SessionNegotiatorFactory;
import org.opendaylight.protocol.framework.SimpleByteToMessageDecoder;
import org.opendaylight.protocol.framework.SimpleMessage;
import org.opendaylight.protocol.framework.SimpleMessageToByteEncoder;
import org.opendaylight.protocol.framework.SimpleSession;
import org.opendaylight.protocol.framework.SimpleSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDispatcher
extends AbstractDispatcher<SimpleSession, SimpleSessionListener> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleDispatcher.class);
    private final SessionNegotiatorFactory<SimpleMessage, SimpleSession, SimpleSessionListener> negotiatorFactory;
    private final ChannelOutboundHandler encoder = new SimpleMessageToByteEncoder();

    public SimpleDispatcher(SessionNegotiatorFactory<SimpleMessage, SimpleSession, SimpleSessionListener> negotiatorFactory, Promise<SimpleSession> promise, EventLoopGroup eventLoopGroup) {
        super(eventLoopGroup, eventLoopGroup);
        this.negotiatorFactory = (SessionNegotiatorFactory)Preconditions.checkNotNull(negotiatorFactory);
    }

    public Future<SimpleSession> createClient(InetSocketAddress address, ReconnectStrategy strategy, SessionListenerFactory<SimpleSessionListener> listenerFactory) {
        return super.createClient(address, strategy, (AbstractDispatcher.PipelineInitializer)new SimplePipelineInitializer(listenerFactory));
    }

    public Future<Void> createReconnectingClient(InetSocketAddress address, ReconnectStrategyFactory strategy, SessionListenerFactory<SimpleSessionListener> listenerFactory) {
        return super.createReconnectingClient(address, strategy, (AbstractDispatcher.PipelineInitializer)new SimplePipelineInitializer(listenerFactory));
    }

    public ChannelFuture createServer(InetSocketAddress address, SessionListenerFactory<SimpleSessionListener> listenerFactory) {
        return super.createServer(address, (AbstractDispatcher.PipelineInitializer)new SimplePipelineInitializer(listenerFactory));
    }

    public void close() {
    }

    private final class SimplePipelineInitializer
    implements AbstractDispatcher.PipelineInitializer<SimpleSession> {
        final SessionListenerFactory<SimpleSessionListener> listenerFactory;

        SimplePipelineInitializer(SessionListenerFactory<SimpleSessionListener> listenerFactory) {
            this.listenerFactory = (SessionListenerFactory)Preconditions.checkNotNull(listenerFactory);
        }

        public void initializeChannel(SocketChannel channel, Promise<SimpleSession> promise) {
            channel.pipeline().addLast(new ChannelHandler[]{new SimpleByteToMessageDecoder()});
            channel.pipeline().addLast("negotiator", (ChannelHandler)SimpleDispatcher.this.negotiatorFactory.getSessionNegotiator(this.listenerFactory, (Channel)channel, promise));
            channel.pipeline().addLast(new ChannelHandler[]{SimpleDispatcher.this.encoder});
            logger.debug("initialization completed for channel {}", (Object)channel);
        }
    }
}

