/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.framework;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.SucceededFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.protocol.framework.NeverReconnectStrategy;
import org.opendaylight.protocol.framework.ReconnectStrategy;
import org.opendaylight.protocol.framework.ReconnectStrategyFactory;
import org.opendaylight.protocol.framework.SessionListenerFactory;
import org.opendaylight.protocol.framework.SessionNegotiator;
import org.opendaylight.protocol.framework.SessionNegotiatorFactory;
import org.opendaylight.protocol.framework.SimpleDispatcher;
import org.opendaylight.protocol.framework.SimpleMessage;
import org.opendaylight.protocol.framework.SimpleSession;
import org.opendaylight.protocol.framework.SimpleSessionListener;
import org.opendaylight.protocol.framework.SimpleSessionNegotiator;

public class ServerTest {
    SimpleDispatcher clientDispatcher;
    SimpleDispatcher dispatcher;
    SimpleSession session = null;
    ChannelFuture server = null;
    InetSocketAddress serverAddress;
    private NioEventLoopGroup eventLoopGroup;
    private NioEventLoopGroup serverLoopGroup;

    @Before
    public void setUp() {
        int port = 10000 + (int)(10000.0 * Math.random());
        this.serverAddress = new InetSocketAddress("127.0.0.1", port);
        this.eventLoopGroup = new NioEventLoopGroup();
        this.serverLoopGroup = new NioEventLoopGroup();
    }

    @After
    public void tearDown() throws IOException, InterruptedException, ExecutionException {
        if (this.server != null) {
            this.server.channel().close();
        }
        this.eventLoopGroup.shutdownGracefully().get();
        this.serverLoopGroup.shutdownGracefully().get();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testConnectionRefused() throws Exception {
        this.clientDispatcher = this.getClientDispatcher();
        ReconnectStrategy mockReconnectStrategy = this.getMockedReconnectStrategy();
        this.clientDispatcher.createClient(this.serverAddress, mockReconnectStrategy, new SessionListenerFactory<SimpleSessionListener>(){

            public SimpleSessionListener getSessionListener() {
                return new SimpleSessionListener();
            }
        });
        ((ReconnectStrategy)Mockito.verify((Object)mockReconnectStrategy, (VerificationMode)Mockito.timeout((int)5000).atLeast(2))).scheduleReconnect((Throwable)Matchers.any(Throwable.class));
    }

    @Test
    public void testConnectionReestablishInitial() throws Exception {
        this.clientDispatcher = this.getClientDispatcher();
        ReconnectStrategy mockReconnectStrategy = this.getMockedReconnectStrategy();
        this.clientDispatcher.createClient(this.serverAddress, mockReconnectStrategy, new SessionListenerFactory<SimpleSessionListener>(){

            public SimpleSessionListener getSessionListener() {
                return new SimpleSessionListener();
            }
        });
        ((ReconnectStrategy)Mockito.verify((Object)mockReconnectStrategy, (VerificationMode)Mockito.timeout((int)5000).atLeast(2))).scheduleReconnect((Throwable)Matchers.any(Throwable.class));
        DefaultPromise p = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.dispatcher = this.getServerDispatcher((Promise<Boolean>)p);
        this.server = this.dispatcher.createServer(this.serverAddress, new SessionListenerFactory<SimpleSessionListener>(){

            public SimpleSessionListener getSessionListener() {
                return new SimpleSessionListener();
            }
        });
        this.server.get();
        Assert.assertEquals((Object)true, (Object)p.get(3L, TimeUnit.SECONDS));
    }

    @Test
    public void testConnectionDrop() throws Exception {
        DefaultPromise p = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.dispatcher = this.getServerDispatcher((Promise<Boolean>)p);
        this.server = this.dispatcher.createServer(this.serverAddress, new SessionListenerFactory<SimpleSessionListener>(){

            public SimpleSessionListener getSessionListener() {
                return new SimpleSessionListener();
            }
        });
        this.server.get();
        this.clientDispatcher = this.getClientDispatcher();
        ReconnectStrategy reconnectStrategy = this.getMockedReconnectStrategy();
        this.session = (SimpleSession)((Object)this.clientDispatcher.createClient(this.serverAddress, reconnectStrategy, new SessionListenerFactory<SimpleSessionListener>(){

            public SimpleSessionListener getSessionListener() {
                return new SimpleSessionListener();
            }
        }).get(6L, TimeUnit.SECONDS));
        Assert.assertEquals((Object)true, (Object)p.get(3L, TimeUnit.SECONDS));
        this.shutdownServer();
        ((ReconnectStrategy)Mockito.verify((Object)reconnectStrategy, (VerificationMode)Mockito.times((int)0))).scheduleReconnect((Throwable)Matchers.any(Throwable.class));
    }

    @Test
    public void testConnectionReestablishAfterDrop() throws Exception {
        DefaultPromise p = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.dispatcher = this.getServerDispatcher((Promise<Boolean>)p);
        this.server = this.dispatcher.createServer(this.serverAddress, new SessionListenerFactory<SimpleSessionListener>(){

            public SimpleSessionListener getSessionListener() {
                return new SimpleSessionListener();
            }
        });
        this.server.get();
        this.clientDispatcher = this.getClientDispatcher();
        ReconnectStrategyFactory reconnectStrategyFactory = (ReconnectStrategyFactory)Mockito.mock(ReconnectStrategyFactory.class);
        ReconnectStrategy reconnectStrategy = this.getMockedReconnectStrategy();
        ((ReconnectStrategyFactory)Mockito.doReturn((Object)reconnectStrategy).when((Object)reconnectStrategyFactory)).createReconnectStrategy();
        this.clientDispatcher.createReconnectingClient(this.serverAddress, reconnectStrategyFactory, new SessionListenerFactory<SimpleSessionListener>(){

            public SimpleSessionListener getSessionListener() {
                return new SimpleSessionListener();
            }
        });
        Assert.assertEquals((Object)true, (Object)p.get(3L, TimeUnit.SECONDS));
        this.shutdownServer();
        ((ReconnectStrategyFactory)Mockito.verify((Object)reconnectStrategyFactory, (VerificationMode)Mockito.timeout((int)20000).atLeast(2))).createReconnectStrategy();
    }

    @Test
    public void testConnectionEstablished() throws Exception {
        DefaultPromise p = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.dispatcher = this.getServerDispatcher((Promise<Boolean>)p);
        this.server = this.dispatcher.createServer(this.serverAddress, new SessionListenerFactory<SimpleSessionListener>(){

            public SimpleSessionListener getSessionListener() {
                return new SimpleSessionListener();
            }
        });
        this.server.get();
        this.clientDispatcher = this.getClientDispatcher();
        this.session = (SimpleSession)((Object)this.clientDispatcher.createClient(this.serverAddress, (ReconnectStrategy)new NeverReconnectStrategy((EventExecutor)GlobalEventExecutor.INSTANCE, 5000), new SessionListenerFactory<SimpleSessionListener>(){

            public SimpleSessionListener getSessionListener() {
                return new SimpleSessionListener();
            }
        }).get(6L, TimeUnit.SECONDS));
        Assert.assertEquals((Object)true, (Object)p.get(3L, TimeUnit.SECONDS));
    }

    @Test
    public void testConnectionFailed() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        DefaultPromise p = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.dispatcher = this.getServerDispatcher((Promise<Boolean>)p);
        this.server = this.dispatcher.createServer(this.serverAddress, new SessionListenerFactory<SimpleSessionListener>(){

            public SimpleSessionListener getSessionListener() {
                return new SimpleSessionListener();
            }
        });
        this.server.get();
        this.clientDispatcher = this.getClientDispatcher();
        this.session = (SimpleSession)((Object)this.clientDispatcher.createClient(this.serverAddress, (ReconnectStrategy)new NeverReconnectStrategy((EventExecutor)GlobalEventExecutor.INSTANCE, 5000), new SessionListenerFactory<SimpleSessionListener>(){

            public SimpleSessionListener getSessionListener() {
                return new SimpleSessionListener();
            }
        }).get(6L, TimeUnit.SECONDS));
        Future<SimpleSession> session = this.clientDispatcher.createClient(this.serverAddress, (ReconnectStrategy)new NeverReconnectStrategy((EventExecutor)GlobalEventExecutor.INSTANCE, 5000), new SessionListenerFactory<SimpleSessionListener>(){

            public SimpleSessionListener getSessionListener() {
                return new SimpleSessionListener();
            }
        });
        Assert.assertFalse((boolean)session.isSuccess());
    }

    @Test
    public void testNegotiationFailedReconnect() throws Exception {
        DefaultPromise p = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.dispatcher = this.getServerDispatcher((Promise<Boolean>)p);
        this.server = this.dispatcher.createServer(this.serverAddress, new SessionListenerFactory<SimpleSessionListener>(){

            public SimpleSessionListener getSessionListener() {
                return new SimpleSessionListener();
            }
        });
        this.server.get();
        this.clientDispatcher = new SimpleDispatcher(new SessionNegotiatorFactory<SimpleMessage, SimpleSession, SimpleSessionListener>(){

            public SessionNegotiator<SimpleSession> getSessionNegotiator(SessionListenerFactory<SimpleSessionListener> factory, Channel channel, Promise<SimpleSession> promise) {
                return new SimpleSessionNegotiator(promise, channel){

                    @Override
                    protected void startNegotiation() throws Exception {
                        this.negotiationFailed(new IllegalStateException("Negotiation failed"));
                    }
                };
            }
        }, (Promise<SimpleSession>)new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE), (EventLoopGroup)this.eventLoopGroup);
        ReconnectStrategyFactory reconnectStrategyFactory = (ReconnectStrategyFactory)Mockito.mock(ReconnectStrategyFactory.class);
        ReconnectStrategy reconnectStrategy = this.getMockedReconnectStrategy();
        ((ReconnectStrategyFactory)Mockito.doReturn((Object)reconnectStrategy).when((Object)reconnectStrategyFactory)).createReconnectStrategy();
        this.clientDispatcher.createReconnectingClient(this.serverAddress, reconnectStrategyFactory, new SessionListenerFactory<SimpleSessionListener>(){

            public SimpleSessionListener getSessionListener() {
                return new SimpleSessionListener();
            }
        });
        ((ReconnectStrategyFactory)Mockito.verify((Object)reconnectStrategyFactory, (VerificationMode)Mockito.timeout((int)((int)TimeUnit.MINUTES.toMillis(3L))).atLeast(2))).createReconnectStrategy();
    }

    private SimpleDispatcher getClientDispatcher() {
        return new SimpleDispatcher(new SessionNegotiatorFactory<SimpleMessage, SimpleSession, SimpleSessionListener>(){

            public SessionNegotiator<SimpleSession> getSessionNegotiator(SessionListenerFactory<SimpleSessionListener> factory, Channel channel, Promise<SimpleSession> promise) {
                return new SimpleSessionNegotiator(promise, channel);
            }
        }, (Promise<SimpleSession>)new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE), (EventLoopGroup)this.eventLoopGroup);
    }

    private ReconnectStrategy getMockedReconnectStrategy() throws Exception {
        ReconnectStrategy mockReconnectStrategy = (ReconnectStrategy)Mockito.mock(ReconnectStrategy.class);
        SucceededFuture future = new SucceededFuture((EventExecutor)GlobalEventExecutor.INSTANCE, null);
        ((ReconnectStrategy)Mockito.doReturn((Object)future).when((Object)mockReconnectStrategy)).scheduleReconnect((Throwable)Matchers.any(Throwable.class));
        ((ReconnectStrategy)Mockito.doReturn((Object)5000).when((Object)mockReconnectStrategy)).getConnectTimeout();
        ((ReconnectStrategy)Mockito.doNothing().when((Object)mockReconnectStrategy)).reconnectSuccessful();
        return mockReconnectStrategy;
    }

    private void shutdownServer() throws InterruptedException, ExecutionException {
        this.server.channel().close().get();
        this.serverLoopGroup.shutdownGracefully().get();
    }

    private SimpleDispatcher getServerDispatcher(final Promise<Boolean> p) {
        return new SimpleDispatcher(new SessionNegotiatorFactory<SimpleMessage, SimpleSession, SimpleSessionListener>(){

            public SessionNegotiator<SimpleSession> getSessionNegotiator(SessionListenerFactory<SimpleSessionListener> factory, Channel channel, Promise<SimpleSession> promise) {
                p.setSuccess((Object)true);
                return new SimpleSessionNegotiator(promise, channel);
            }
        }, null, (EventLoopGroup)this.serverLoopGroup);
    }
}

