/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.protocol.framework;

import java.math.BigDecimal;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.manager.impl.AbstractConfigTest;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.HardcodedModuleFactoriesResolver;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.ModuleFactoriesResolver;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.util.ConfigTransactionJMXClient;
import org.opendaylight.controller.config.yang.netty.eventexecutor.GlobalEventExecutorModuleFactory;
import org.opendaylight.controller.config.yang.protocol.framework.GlobalEventExecutorUtil;
import org.opendaylight.controller.config.yang.protocol.framework.TimedReconnectStrategyFactoryModuleFactory;
import org.opendaylight.controller.config.yang.protocol.framework.TimedReconnectStrategyFactoryModuleMXBean;

public class TimedReconnectStrategyModuleTest
extends AbstractConfigTest {
    private static final String INSTANCE_NAME = "timed-reconect-stategy-facotry-impl";
    private static final String FACTORY_NAME = "timed-reconnect-strategy-factory";

    @Before
    public void setUp() throws Exception {
        super.initConfigTransactionManagerImpl((ModuleFactoriesResolver)new HardcodedModuleFactoriesResolver(this.mockedContext, new ModuleFactory[]{new TimedReconnectStrategyFactoryModuleFactory(), new GlobalEventExecutorModuleFactory()}));
    }

    @Test
    public void testValidationExceptionSleepFactorNotSet() throws Exception {
        try {
            this.createInstance(500, 100L, null, 500L, 10L, 10000L);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("SleepFactor value is not set."));
        }
    }

    @Test
    public void testValidationExceptionSleepFactorMinValue() throws Exception {
        try {
            this.createInstance(500, 100L, new BigDecimal(0.5), 500L, 10L, 10000L);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is less than 1"));
        }
    }

    @Test
    public void testValidationExceptionConnectTimeNotSet() throws Exception {
        try {
            this.createInstance(null, 100L, new BigDecimal(1.0), 500L, 10L, 10000L);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("ConnectTime value is not set."));
        }
    }

    @Test
    public void testValidationExceptionConnectTimeMinValue() throws Exception {
        try {
            this.createInstance(-1, 100L, new BigDecimal(1.0), 500L, 10L, 10000L);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is less than 0"));
        }
    }

    @Test
    public void testValidationExceptionMinSleepNotSet() throws Exception {
        try {
            this.createInstance(100, null, new BigDecimal(1.0), 100L, 10L, 10000L);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("MinSleep value is not set."));
        }
    }

    @Test
    public void testValidationExceptionMaxSleep() throws Exception {
        try {
            this.createInstance(100, 300L, new BigDecimal(1.0), 100L, 10L, 10000L);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is greter than MaxSleep"));
        }
    }

    @Test
    public void testCreateBean() throws Exception {
        CommitStatus status = this.createInstance();
        this.assertBeanCount(1, FACTORY_NAME);
        this.assertStatus(status, 2, 0, 0);
    }

    @Test
    public void testReusingOldInstance() throws Exception {
        this.createInstance();
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        this.assertBeanCount(1, FACTORY_NAME);
        CommitStatus status = transaction.commit();
        this.assertBeanCount(1, FACTORY_NAME);
        this.assertStatus(status, 0, 0, 2);
    }

    @Test
    public void testReconfigure() throws Exception {
        this.createInstance();
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        this.assertBeanCount(1, FACTORY_NAME);
        TimedReconnectStrategyFactoryModuleMXBean mxBean = (TimedReconnectStrategyFactoryModuleMXBean)transaction.newMXBeanProxy(transaction.lookupConfigBean(FACTORY_NAME, INSTANCE_NAME), TimedReconnectStrategyFactoryModuleMXBean.class);
        Assert.assertEquals((Object)mxBean.getMinSleep(), (Object)new Long(100L));
        mxBean.setMinSleep(Long.valueOf(200L));
        Assert.assertEquals((Object)mxBean.getMinSleep(), (Object)new Long(200L));
        CommitStatus status = transaction.commit();
        this.assertBeanCount(1, FACTORY_NAME);
        this.assertStatus(status, 0, 1, 1);
    }

    private CommitStatus createInstance() throws Exception {
        return this.createInstance(500, 100L, new BigDecimal(1.0), 500L, 10L, 10000L);
    }

    private CommitStatus createInstance(Integer connectTime, Long minSleep, BigDecimal sleepFactor, Long maxSleep, Long maxAttempts, Long deadline) throws ConflictingVersionException, ValidationException, InstanceAlreadyExistsException {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        TimedReconnectStrategyModuleTest.createInstance(transaction, INSTANCE_NAME, connectTime, minSleep, sleepFactor, maxSleep, maxAttempts, deadline);
        return transaction.commit();
    }

    public static ObjectName createInstance(ConfigTransactionJMXClient transaction, String InstanceName) throws Exception {
        return TimedReconnectStrategyModuleTest.createInstance(transaction, InstanceName, 500, 100L, new BigDecimal(1.0), 500L, 10L, 10000L);
    }

    private static ObjectName createInstance(ConfigTransactionJMXClient transaction, String instanceName, Integer connectTime, Long minSleep, BigDecimal sleepFactor, Long maxSleep, Long maxAttempts, Long deadline) throws InstanceAlreadyExistsException {
        ObjectName nameCreated = transaction.createModule(FACTORY_NAME, instanceName);
        TimedReconnectStrategyFactoryModuleMXBean mxBean = (TimedReconnectStrategyFactoryModuleMXBean)transaction.newMXBeanProxy(nameCreated, TimedReconnectStrategyFactoryModuleMXBean.class);
        mxBean.setConnectTime(connectTime);
        mxBean.setDeadline(deadline);
        mxBean.setMaxAttempts(maxAttempts);
        mxBean.setMaxSleep(maxSleep);
        mxBean.setMinSleep(minSleep);
        mxBean.setSleepFactor(sleepFactor);
        mxBean.setTimedReconnectExecutor(GlobalEventExecutorUtil.create(transaction));
        return nameCreated;
    }
}

