/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.protocol.framework;

import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.manager.impl.AbstractConfigTest;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.HardcodedModuleFactoriesResolver;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.ModuleFactoriesResolver;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.util.ConfigTransactionJMXClient;
import org.opendaylight.controller.config.yang.netty.eventexecutor.GlobalEventExecutorModuleFactory;
import org.opendaylight.controller.config.yang.protocol.framework.GlobalEventExecutorUtil;
import org.opendaylight.controller.config.yang.protocol.framework.NeverReconnectStrategyFactoryModuleFactory;
import org.opendaylight.controller.config.yang.protocol.framework.NeverReconnectStrategyFactoryModuleMXBean;

public class NeverReconnectStrategyModuleTest
extends AbstractConfigTest {
    private static final String INSTANCE_NAME = "never-reconect-strategy-factory-impl";
    private static final String FACTORY_NAME = "never-reconnect-strategy-factory";

    @Before
    public void setUp() throws Exception {
        super.initConfigTransactionManagerImpl((ModuleFactoriesResolver)new HardcodedModuleFactoriesResolver(this.mockedContext, new ModuleFactory[]{new NeverReconnectStrategyFactoryModuleFactory(), new GlobalEventExecutorModuleFactory()}));
    }

    @Test
    public void testValidationExceptionTimeoutNotSet() throws Exception {
        try {
            this.createInstance(null);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Timeout value is not set."));
        }
    }

    @Test
    public void testValidationExceptionTimeoutMinValue() throws Exception {
        try {
            this.createInstance(-1);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is less than 0"));
        }
    }

    @Test
    public void testCreateBean() throws Exception {
        CommitStatus status = this.createInstance();
        this.assertBeanCount(1, FACTORY_NAME);
        this.assertStatus(status, 2, 0, 0);
    }

    @Test
    public void testReusingOldInstance() throws Exception {
        this.createInstance();
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        this.assertBeanCount(1, FACTORY_NAME);
        CommitStatus status = transaction.commit();
        this.assertBeanCount(1, FACTORY_NAME);
        this.assertStatus(status, 0, 0, 2);
    }

    @Test
    public void testReconfigure() throws Exception {
        this.createInstance();
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        this.assertBeanCount(1, FACTORY_NAME);
        NeverReconnectStrategyFactoryModuleMXBean mxBean = (NeverReconnectStrategyFactoryModuleMXBean)transaction.newMXBeanProxy(transaction.lookupConfigBean(FACTORY_NAME, INSTANCE_NAME), NeverReconnectStrategyFactoryModuleMXBean.class);
        mxBean.setTimeout(Integer.valueOf(200));
        CommitStatus status = transaction.commit();
        this.assertBeanCount(1, FACTORY_NAME);
        this.assertStatus(status, 0, 1, 1);
    }

    private CommitStatus createInstance() throws Exception {
        return this.createInstance(500);
    }

    private CommitStatus createInstance(Integer timeout) throws InstanceAlreadyExistsException, ConflictingVersionException, ValidationException {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        NeverReconnectStrategyModuleTest.createInstance(transaction, timeout);
        return transaction.commit();
    }

    private static ObjectName createInstance(ConfigTransactionJMXClient transaction, Integer timeout) throws InstanceAlreadyExistsException {
        ObjectName nameCreated = transaction.createModule(FACTORY_NAME, INSTANCE_NAME);
        NeverReconnectStrategyFactoryModuleMXBean mxBean = (NeverReconnectStrategyFactoryModuleMXBean)transaction.newMXBeanProxy(nameCreated, NeverReconnectStrategyFactoryModuleMXBean.class);
        mxBean.setTimeout(timeout);
        mxBean.setExecutor(GlobalEventExecutorUtil.create(transaction));
        return nameCreated;
    }
}

