package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.netty.hashed.wheel.timer.ThreadFactory;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer
 *
 */
public class NettyHashedWheelTimerBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer> {

    private ThreadFactory _threadFactory;
    private java.lang.Long _tickDuration;
    private java.lang.Integer _ticksPerWheel;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>> augmentation = Collections.emptyMap();

    public NettyHashedWheelTimerBuilder() {
    }

    public NettyHashedWheelTimerBuilder(NettyHashedWheelTimer base) {
        this._threadFactory = base.getThreadFactory();
        this._tickDuration = base.getTickDuration();
        this._ticksPerWheel = base.getTicksPerWheel();
        if (base instanceof NettyHashedWheelTimerImpl) {
            NettyHashedWheelTimerImpl impl = (NettyHashedWheelTimerImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public ThreadFactory getThreadFactory() {
        return _threadFactory;
    }
    
    public java.lang.Long getTickDuration() {
        return _tickDuration;
    }
    
    public java.lang.Integer getTicksPerWheel() {
        return _ticksPerWheel;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public NettyHashedWheelTimerBuilder setThreadFactory(final ThreadFactory value) {
        this._threadFactory = value;
        return this;
    }
    
     
     private static void checkTickDurationRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public NettyHashedWheelTimerBuilder setTickDuration(final java.lang.Long value) {
    if (value != null) {
        checkTickDurationRange(value);
    }
        this._tickDuration = value;
        return this;
    }
    
     
     private static void checkTicksPerWheelRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
     }
    
    public NettyHashedWheelTimerBuilder setTicksPerWheel(final java.lang.Integer value) {
    if (value != null) {
        checkTicksPerWheelRange(value);
    }
        this._ticksPerWheel = value;
        return this;
    }
    
    public NettyHashedWheelTimerBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public NettyHashedWheelTimerBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NettyHashedWheelTimer build() {
        return new NettyHashedWheelTimerImpl(this);
    }

    private static final class NettyHashedWheelTimerImpl implements NettyHashedWheelTimer {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer.class;
        }

        private final ThreadFactory _threadFactory;
        private final java.lang.Long _tickDuration;
        private final java.lang.Integer _ticksPerWheel;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>> augmentation = Collections.emptyMap();

        private NettyHashedWheelTimerImpl(NettyHashedWheelTimerBuilder base) {
            this._threadFactory = base.getThreadFactory();
            this._tickDuration = base.getTickDuration();
            this._ticksPerWheel = base.getTicksPerWheel();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return _threadFactory;
        }
        
        @Override
        public java.lang.Long getTickDuration() {
            return _tickDuration;
        }
        
        @Override
        public java.lang.Integer getTicksPerWheel() {
            return _ticksPerWheel;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_threadFactory);
            result = prime * result + Objects.hashCode(_tickDuration);
            result = prime * result + Objects.hashCode(_ticksPerWheel);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer)obj;
            if (!Objects.equals(_threadFactory, other.getThreadFactory())) {
                return false;
            }
            if (!Objects.equals(_tickDuration, other.getTickDuration())) {
                return false;
            }
            if (!Objects.equals(_ticksPerWheel, other.getTicksPerWheel())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NettyHashedWheelTimerImpl otherImpl = (NettyHashedWheelTimerImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("NettyHashedWheelTimer [");
            boolean first = true;
        
            if (_threadFactory != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_threadFactory=");
                builder.append(_threadFactory);
             }
            if (_tickDuration != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tickDuration=");
                builder.append(_tickDuration);
             }
            if (_ticksPerWheel != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ticksPerWheel=");
                builder.append(_ticksPerWheel);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
