package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.netty.hashed.wheel.timer.ThreadFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.module.Configuration;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>netty-timer</b>
 * <br>(Source path: <i>META-INF/yang/netty-timer.yang</i>):
 * <pre>
 * case netty-hashed-wheel-timer {
 *     leaf tick-duration {
 *         type uint32;
 *     }
 *     leaf ticks-per-wheel {
 *         type uint16;
 *     }
 *     container thread-factory {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (urn:opendaylight:params:xml:ns:yang:controller:netty:timer?revision=2013-11-19)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>netty-timer/modules/module/configuration/(urn:opendaylight:params:xml:ns:yang:controller:netty:timer?revision=2013-11-19)netty-hashed-wheel-timer</i>
 *
 */
public interface NettyHashedWheelTimer
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer>,
    Configuration
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:netty:timer",
        "2013-11-19", "netty-hashed-wheel-timer").intern();

    java.lang.Long getTickDuration();
    
    java.lang.Integer getTicksPerWheel();
    
    ThreadFactory getThreadFactory();

}

