/*
 * Copyright (c) 2013 Cisco Systems, Inc. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */

/**
 * Generated file

 * Generated from: yang module name: netty-event-executor  yang module local name: netty-hashed-wheel-timer
 * Generated by: org.opendaylight.controller.config.yangjmxgenerator.plugin.JMXGenerator
 * Generated at: Tue Nov 19 12:49:59 CET 2013
 *
 * Do not modify this file unless it is present under src/main directory
 */
package org.opendaylight.controller.config.yang.netty.timer;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.config.api.JmxAttributeValidationException;

/**
*
*/
public final class HashedWheelTimerModule extends
        org.opendaylight.controller.config.yang.netty.timer.AbstractHashedWheelTimerModule {

    public HashedWheelTimerModule(org.opendaylight.controller.config.api.ModuleIdentifier identifier,
            org.opendaylight.controller.config.api.DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public HashedWheelTimerModule(org.opendaylight.controller.config.api.ModuleIdentifier identifier,
            org.opendaylight.controller.config.api.DependencyResolver dependencyResolver,
            HashedWheelTimerModule oldModule, java.lang.AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        super.validate();
        if (getTickDuration() != null) {
            JmxAttributeValidationException.checkCondition(getTickDuration() > 0, "value must be greater than 0",
                    tickDurationJmxAttribute);
        }
        if (getTicksPerWheel() != null) {
            JmxAttributeValidationException.checkCondition(getTicksPerWheel() > 0, "value must be greater than 0",
                    ticksPerWheelJmxAttribute);
        }
    }

    @Override
    public java.lang.AutoCloseable createInstance() {
        TimeUnit unit = TimeUnit.MILLISECONDS;
        if (getTickDuration() != null && getThreadFactoryDependency() == null && getTicksPerWheel() == null) {
            return new HashedWheelTimerCloseable(new HashedWheelTimer(getTickDuration(), unit));
        }
        if (getTickDuration() != null && getThreadFactoryDependency() == null && getTicksPerWheel() != null) {
            return new HashedWheelTimerCloseable(new HashedWheelTimer(getTickDuration(), unit, getTicksPerWheel()));
        }
        if (getTickDuration() == null && getThreadFactoryDependency() != null && getTicksPerWheel() == null) {
            return new HashedWheelTimerCloseable(new HashedWheelTimer(getThreadFactoryDependency()));
        }
        if (getTickDuration() != null && getThreadFactoryDependency() != null && getTicksPerWheel() == null) {
            return new HashedWheelTimerCloseable(new HashedWheelTimer(getThreadFactoryDependency(), getTickDuration(),
                    unit));
        }
        if (getTickDuration() != null && getThreadFactoryDependency() != null && getTicksPerWheel() != null) {
            return new HashedWheelTimerCloseable(new HashedWheelTimer(getThreadFactoryDependency(), getTickDuration(),
                    unit, getTicksPerWheel()));
        }
        return new HashedWheelTimerCloseable(new HashedWheelTimer());
    }

    static final private class HashedWheelTimerCloseable implements AutoCloseable, Timer {

        private final Timer timer;

        public HashedWheelTimerCloseable(Timer timer) {
            this.timer = timer;
        }

        @Override
        public void close() throws Exception {
            stop();
        }

        @Override
        public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
            return this.timer.newTimeout(task, delay, unit);
        }

        @Override
        public Set<Timeout> stop() {
            return this.timer.stop();
        }

    }
}
