/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.messagebus.app.impl;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.messagebus.app.impl.EventSourceRegistrationImpl;
import org.opendaylight.controller.messagebus.app.impl.EventSourceTopic;
import org.opendaylight.controller.messagebus.app.impl.Util;
import org.opendaylight.controller.messagebus.spi.EventSource;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistration;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistry;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.CreateTopicInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.CreateTopicOutput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.CreateTopicOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.DestroyTopicInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.EventAggregatorService;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.NotificationPattern;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.EventSourceService;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.Node1;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.Node1Builder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.TopologyTypes1;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.TopologyTypes1Builder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.topology.event.source.type.TopologyEventSource;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.topology.event.source.type.TopologyEventSourceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContext;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.TopologyTypes;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSourceTopology
implements EventAggregatorService,
EventSourceRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(EventSourceTopology.class);
    private static final String TOPOLOGY_ID = "EVENT-SOURCE-TOPOLOGY";
    private static final TopologyKey EVENT_SOURCE_TOPOLOGY_KEY = new TopologyKey(new TopologyId("EVENT-SOURCE-TOPOLOGY"));
    private static final LogicalDatastoreType OPERATIONAL = LogicalDatastoreType.OPERATIONAL;
    static final InstanceIdentifier<Topology> EVENT_SOURCE_TOPOLOGY_PATH = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Identifier)EVENT_SOURCE_TOPOLOGY_KEY);
    private static final InstanceIdentifier<TopologyTypes1> TOPOLOGY_TYPE_PATH = EVENT_SOURCE_TOPOLOGY_PATH.child(TopologyTypes.class).augmentation(TopologyTypes1.class);
    private final Map<TopicId, EventSourceTopic> eventSourceTopicMap = new ConcurrentHashMap<TopicId, EventSourceTopic>();
    private final Map<NodeKey, BindingAwareBroker.RoutedRpcRegistration<EventSourceService>> routedRpcRegistrations = new ConcurrentHashMap<NodeKey, BindingAwareBroker.RoutedRpcRegistration<EventSourceService>>();
    private final DataBroker dataBroker;
    private final BindingAwareBroker.RpcRegistration<EventAggregatorService> aggregatorRpcReg;
    private final EventSourceService eventSourceService;
    private final RpcProviderRegistry rpcRegistry;

    public EventSourceTopology(DataBroker dataBroker, RpcProviderRegistry rpcRegistry) {
        this.dataBroker = dataBroker;
        this.rpcRegistry = rpcRegistry;
        this.aggregatorRpcReg = rpcRegistry.addRpcImplementation(EventAggregatorService.class, (RpcService)this);
        this.eventSourceService = (EventSourceService)rpcRegistry.getRpcService(EventSourceService.class);
        TopologyEventSource topologySource = new TopologyEventSourceBuilder().build();
        TopologyTypes1 topologyTypeAugment = new TopologyTypes1Builder().setTopologyEventSource(topologySource).build();
        this.putData(OPERATIONAL, TOPOLOGY_TYPE_PATH, topologyTypeAugment);
        LOG.info("EventSourceRegistry has been initialized");
    }

    private <T extends DataObject> void putData(final LogicalDatastoreType store, final InstanceIdentifier<T> path, T data) {
        WriteTransaction tx = this.getDataBroker().newWriteOnlyTransaction();
        tx.put(store, path, data, true);
        Futures.addCallback((ListenableFuture)tx.submit(), (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                LOG.trace("Data has put into datastore {} {}", (Object)store, (Object)path);
            }

            public void onFailure(Throwable t) {
                LOG.error("Can not put data into datastore [store: {}] [path: {}] [exception: {}]", new Object[]{store, path, t});
            }
        });
    }

    private <T extends DataObject> void deleteData(final LogicalDatastoreType store, final InstanceIdentifier<T> path) {
        WriteTransaction tx = this.getDataBroker().newWriteOnlyTransaction();
        tx.delete(OPERATIONAL, path);
        tx.submit();
        Futures.addCallback((ListenableFuture)tx.submit(), (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                LOG.trace("Data has deleted from datastore {} {}", (Object)store, (Object)path);
            }

            public void onFailure(Throwable t) {
                LOG.error("Can not delete data from datastore [store: {}] [path: {}] [exception: {}]", new Object[]{store, path, t});
            }
        });
    }

    private void insert(KeyedInstanceIdentifier<Node, NodeKey> sourcePath) {
        NodeKey nodeKey = (NodeKey)sourcePath.getKey();
        InstanceIdentifier augmentPath = sourcePath.augmentation(Node1.class);
        Node1 nodeAgument = new Node1Builder().setEventSourceNode(new NodeId(nodeKey.getNodeId().getValue())).build();
        this.putData(OPERATIONAL, augmentPath, nodeAgument);
    }

    private void remove(KeyedInstanceIdentifier<Node, NodeKey> sourcePath) {
        InstanceIdentifier augmentPath = sourcePath.augmentation(Node1.class);
        this.deleteData(OPERATIONAL, augmentPath);
    }

    public Future<RpcResult<CreateTopicOutput>> createTopic(CreateTopicInput input) {
        LOG.debug("Received Topic creation request: NotificationPattern -> {}, NodeIdPattern -> {}", (Object)input.getNotificationPattern(), (Object)input.getNodeIdPattern());
        NotificationPattern notificationPattern = new NotificationPattern(input.getNotificationPattern());
        String nodeIdRegexPattern = Util.wildcardToRegex(input.getNodeIdPattern().getValue());
        EventSourceTopic eventSourceTopic = EventSourceTopic.create(notificationPattern, nodeIdRegexPattern, this);
        this.eventSourceTopicMap.put(eventSourceTopic.getTopicId(), eventSourceTopic);
        CreateTopicOutput cto = new CreateTopicOutputBuilder().setTopicId(eventSourceTopic.getTopicId()).build();
        LOG.info("Topic has been created: NotificationPattern -> {}, NodeIdPattern -> {}", (Object)input.getNotificationPattern(), (Object)input.getNodeIdPattern());
        return Util.resultRpcSuccessFor(cto);
    }

    public Future<RpcResult<Void>> destroyTopic(DestroyTopicInput input) {
        EventSourceTopic topicToDestroy = this.eventSourceTopicMap.remove(input.getTopicId());
        if (topicToDestroy != null) {
            topicToDestroy.close();
        }
        return Util.resultRpcSuccessFor(null);
    }

    public void close() {
        this.aggregatorRpcReg.close();
        for (EventSourceTopic est : this.eventSourceTopicMap.values()) {
            est.close();
        }
    }

    public void register(EventSource eventSource) {
        NodeKey nodeKey = eventSource.getSourceNodeKey();
        KeyedInstanceIdentifier sourcePath = EVENT_SOURCE_TOPOLOGY_PATH.child(Node.class, (Identifier)nodeKey);
        BindingAwareBroker.RoutedRpcRegistration reg = this.rpcRegistry.addRoutedRpcImplementation(EventSourceService.class, (RpcService)eventSource);
        reg.registerPath(NodeContext.class, (Path)sourcePath);
        this.routedRpcRegistrations.put(nodeKey, (BindingAwareBroker.RoutedRpcRegistration<EventSourceService>)reg);
        this.insert((KeyedInstanceIdentifier<Node, NodeKey>)sourcePath);
    }

    public void unRegister(EventSource eventSource) {
        NodeKey nodeKey = eventSource.getSourceNodeKey();
        KeyedInstanceIdentifier sourcePath = EVENT_SOURCE_TOPOLOGY_PATH.child(Node.class, (Identifier)nodeKey);
        BindingAwareBroker.RoutedRpcRegistration<EventSourceService> removeRegistration = this.routedRpcRegistrations.remove(nodeKey);
        if (removeRegistration != null) {
            removeRegistration.close();
            this.remove((KeyedInstanceIdentifier<Node, NodeKey>)sourcePath);
        }
    }

    public <T extends EventSource> EventSourceRegistration<T> registerEventSource(T eventSource) {
        EventSourceRegistrationImpl<T> esr = new EventSourceRegistrationImpl<T>(eventSource, this);
        this.register(eventSource);
        return esr;
    }

    DataBroker getDataBroker() {
        return this.dataBroker;
    }

    EventSourceService getEventSourceService() {
        return this.eventSourceService;
    }
}

