/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.messagebus.app.impl;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.messagebus.app.impl.AbstractMessageBusAppImplModule;
import org.opendaylight.controller.config.yang.messagebus.app.impl.Providers;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.MountPointService;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPointService;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationPublishService;
import org.opendaylight.controller.messagebus.app.impl.EventSourceTopology;
import org.opendaylight.controller.messagebus.eventsources.netconf.NetconfEventSourceManager;
import org.opendaylight.controller.messagebus.spi.EventSource;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistration;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistry;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.Provider;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBusAppImplModule
extends AbstractMessageBusAppImplModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageBusAppImplModule.class);
    private BundleContext bundleContext;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public MessageBusAppImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public MessageBusAppImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, MessageBusAppImplModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    protected void customValidation() {
    }

    public AutoCloseable createInstance() {
        BindingAwareBroker.ProviderContext bindingCtx = this.getBindingBrokerDependency().registerProvider((BindingAwareProvider)new Providers.BindingAware());
        Broker.ProviderSession domCtx = this.getDomBrokerDependency().registerProvider((Provider)new Providers.BindingIndependent());
        DataBroker dataBroker = (DataBroker)bindingCtx.getSALService(DataBroker.class);
        DOMNotificationPublishService domPublish = (DOMNotificationPublishService)domCtx.getService(DOMNotificationPublishService.class);
        DOMMountPointService domMount = (DOMMountPointService)domCtx.getService(DOMMountPointService.class);
        RpcProviderRegistry rpcRegistry = (RpcProviderRegistry)bindingCtx.getSALService(RpcProviderRegistry.class);
        MountPointService mountPointService = (MountPointService)bindingCtx.getSALService(MountPointService.class);
        EventSourceRegistryWrapper eventSourceRegistryWrapper = new EventSourceRegistryWrapper(new EventSourceTopology(dataBroker, rpcRegistry));
        NetconfEventSourceManager netconfEventSourceManager = NetconfEventSourceManager.create(dataBroker, domPublish, domMount, mountPointService, eventSourceRegistryWrapper, this.getNamespaceToStream());
        eventSourceRegistryWrapper.addAutoCloseable(netconfEventSourceManager);
        LOGGER.info("Messagebus initialized");
        return eventSourceRegistryWrapper;
    }

    private class EventSourceRegistryWrapper
    implements EventSourceRegistry {
        private final EventSourceRegistry baseEventSourceRegistry;
        private final Set<AutoCloseable> autoCloseables = new HashSet<AutoCloseable>();

        public EventSourceRegistryWrapper(EventSourceRegistry baseEventSourceRegistry) {
            this.baseEventSourceRegistry = baseEventSourceRegistry;
        }

        public void addAutoCloseable(AutoCloseable ac) {
            Preconditions.checkNotNull((Object)ac);
            this.autoCloseables.add(ac);
        }

        public void close() throws Exception {
            for (AutoCloseable ac : this.autoCloseables) {
                ac.close();
            }
            this.baseEventSourceRegistry.close();
        }

        public <T extends EventSource> EventSourceRegistration<T> registerEventSource(T eventSource) {
            return this.baseEventSourceRegistry.registerEventSource(eventSource);
        }
    }
}

