/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.messagebus.eventsources.netconf;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.MountPoint;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMEvent;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPoint;
import org.opendaylight.controller.md.sal.dom.api.DOMNotification;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationListener;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationPublishService;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationService;
import org.opendaylight.controller.messagebus.app.impl.TopicDOMNotification;
import org.opendaylight.controller.messagebus.app.impl.Util;
import org.opendaylight.controller.messagebus.eventsources.netconf.ConnectionNotificationTopicRegistration;
import org.opendaylight.controller.messagebus.eventsources.netconf.NotificationTopicRegistration;
import org.opendaylight.controller.messagebus.eventsources.netconf.StreamNotificationTopicRegistration;
import org.opendaylight.controller.messagebus.spi.EventSource;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.opendaylight.controller.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.NotificationPattern;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicNotification;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.DisJoinTopicInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicOutput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicStatus;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NetconfEventSource
implements EventSource,
DOMNotificationListener {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfEventSource.class);
    private static final YangInstanceIdentifier.NodeIdentifier TOPIC_NOTIFICATION_ARG = new YangInstanceIdentifier.NodeIdentifier(TopicNotification.QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier EVENT_SOURCE_ARG = new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)TopicNotification.QNAME, (String)"node-id"));
    private static final YangInstanceIdentifier.NodeIdentifier TOPIC_ID_ARG = new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)TopicNotification.QNAME, (String)"topic-id"));
    private static final YangInstanceIdentifier.NodeIdentifier PAYLOAD_ARG = new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)TopicNotification.QNAME, (String)"payload"));
    private static final String ConnectionNotificationSourceName = "ConnectionNotificationSource";
    private final String nodeId;
    private final Node node;
    private final DOMMountPoint netconfMount;
    private final MountPoint mountPoint;
    private final DOMNotificationPublishService domPublish;
    private final Map<String, String> urnPrefixToStreamMap;
    private final List<NotificationTopicRegistration> notificationTopicRegistrationList = new ArrayList<NotificationTopicRegistration>();

    public NetconfEventSource(Node node, Map<String, String> streamMap, DOMMountPoint netconfMount, MountPoint mountPoint, DOMNotificationPublishService publishService) {
        this.netconfMount = (DOMMountPoint)Preconditions.checkNotNull((Object)netconfMount);
        this.mountPoint = (MountPoint)Preconditions.checkNotNull((Object)mountPoint);
        this.node = (Node)Preconditions.checkNotNull((Object)node);
        this.urnPrefixToStreamMap = (Map)Preconditions.checkNotNull(streamMap);
        this.domPublish = (DOMNotificationPublishService)Preconditions.checkNotNull((Object)publishService);
        this.nodeId = node.getNodeId().getValue();
        this.initializeNotificationTopicRegistrationList();
        LOG.info("NetconfEventSource [{}] created.", (Object)this.nodeId);
    }

    private void initializeNotificationTopicRegistrationList() {
        this.notificationTopicRegistrationList.add(new ConnectionNotificationTopicRegistration(ConnectionNotificationSourceName, this));
        Optional<Map<String, Stream>> streamMap = this.getAvailableStreams();
        if (streamMap.isPresent()) {
            LOG.debug("Stream configuration compare...");
            for (String urnPrefix : this.urnPrefixToStreamMap.keySet()) {
                String streamName = this.urnPrefixToStreamMap.get(urnPrefix);
                LOG.debug("urnPrefix: {} streamName: {}", (Object)urnPrefix, (Object)streamName);
                if (!((Map)streamMap.get()).containsKey(streamName)) continue;
                LOG.debug("Stream containig on device");
                this.notificationTopicRegistrationList.add(new StreamNotificationTopicRegistration((Stream)((Map)streamMap.get()).get(streamName), urnPrefix, this));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Optional<Map<String, Stream>> getAvailableStreams() {
        HashMap<String, Stream> streamMap = null;
        InstanceIdentifier pathStream = InstanceIdentifier.builder(Netconf.class).child(Streams.class).build();
        Optional dataBroker = this.mountPoint.getService(DataBroker.class);
        if (dataBroker.isPresent()) {
            LOG.debug("GET Available streams ...");
            ReadOnlyTransaction tx = ((DataBroker)dataBroker.get()).newReadOnlyTransaction();
            CheckedFuture checkFeature = tx.read(LogicalDatastoreType.OPERATIONAL, pathStream);
            try {
                Optional streams = (Optional)checkFeature.checkedGet();
                if (!streams.isPresent()) return Optional.fromNullable(streamMap);
                streamMap = new HashMap<String, Stream>();
                for (Stream stream : ((Streams)streams.get()).getStream()) {
                    LOG.debug("*** find stream {}", (Object)stream.getName().getValue());
                    streamMap.put(stream.getName().getValue(), stream);
                }
                return Optional.fromNullable(streamMap);
            }
            catch (ReadFailedException e) {
                LOG.warn("Can not read streams for node {}", (Object)this.nodeId);
                return Optional.fromNullable(streamMap);
            }
        } else {
            LOG.warn("No databroker on node {}", (Object)this.nodeId);
        }
        return Optional.fromNullable(streamMap);
    }

    public Future<RpcResult<JoinTopicOutput>> joinTopic(JoinTopicInput input) {
        LOG.debug("Join topic {} on {}", (Object)input.getTopicId().getValue(), (Object)this.nodeId);
        NotificationPattern notificationPattern = input.getNotificationPattern();
        List<SchemaPath> matchingNotifications = this.getMatchingNotifications(notificationPattern);
        return this.registerTopic(input.getTopicId(), matchingNotifications);
    }

    public Future<RpcResult<Void>> disJoinTopic(DisJoinTopicInput input) {
        for (NotificationTopicRegistration reg : this.notificationTopicRegistrationList) {
            reg.unRegisterNotificationTopic(input.getTopicId());
        }
        return Util.resultRpcSuccessFor(null);
    }

    private synchronized Future<RpcResult<JoinTopicOutput>> registerTopic(TopicId topicId, List<SchemaPath> notificationsToSubscribe) {
        LOG.debug("Join topic {} - register");
        JoinTopicStatus joinTopicStatus = JoinTopicStatus.Down;
        if (notificationsToSubscribe != null && !notificationsToSubscribe.isEmpty()) {
            LOG.debug("Notifications to subscribe has found - count {}", (Object)notificationsToSubscribe.size());
            Optional notifyService = this.getDOMMountPoint().getService(DOMNotificationService.class);
            if (notifyService.isPresent()) {
                int registeredNotificationCount = 0;
                for (SchemaPath schemaNotification : notificationsToSubscribe) {
                    for (NotificationTopicRegistration reg : this.notificationTopicRegistrationList) {
                        LOG.debug("Try notification registratio {} on SchemaPathNotification {}", (Object)reg.getSourceName(), (Object)schemaNotification.getLastComponent().getLocalName());
                        if (!reg.checkNotificationPath(schemaNotification)) continue;
                        LOG.info("Source of notification {} is activating, TopicId {}", (Object)reg.getSourceName(), (Object)topicId.getValue());
                        boolean regSuccess = reg.registerNotificationTopic(schemaNotification, topicId);
                        if (!regSuccess) continue;
                        ++registeredNotificationCount;
                    }
                }
                if (registeredNotificationCount > 0) {
                    joinTopicStatus = JoinTopicStatus.Up;
                }
            } else {
                LOG.warn("NO DOMNotification service on node {}", (Object)this.nodeId);
            }
        } else {
            LOG.debug("Notifications to subscribe has NOT found");
        }
        JoinTopicOutput output = new JoinTopicOutputBuilder().setStatus(joinTopicStatus).build();
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)output).build());
    }

    public void reActivateStreams() {
        for (NotificationTopicRegistration reg : this.notificationTopicRegistrationList) {
            LOG.info("Source of notification {} is reactivating on node {}", (Object)reg.getSourceName(), (Object)this.nodeId);
            reg.reActivateNotificationSource();
        }
    }

    public void deActivateStreams() {
        for (NotificationTopicRegistration reg : this.notificationTopicRegistrationList) {
            LOG.info("Source of notification {} is deactivating on node {}", (Object)reg.getSourceName(), (Object)this.nodeId);
            reg.deActivateNotificationSource();
        }
    }

    public void onNotification(DOMNotification notification) {
        SchemaPath notificationPath = notification.getType();
        Date notificationEventTime = null;
        if (notification instanceof DOMEvent) {
            notificationEventTime = ((DOMEvent)notification).getEventTime();
        }
        for (NotificationTopicRegistration notifReg : this.notificationTopicRegistrationList) {
            ArrayList<TopicId> topicIdsForNotification = notifReg.getNotificationTopicIds(notificationPath);
            if (topicIdsForNotification == null || topicIdsForNotification.isEmpty()) continue;
            if (notifReg instanceof StreamNotificationTopicRegistration) {
                StreamNotificationTopicRegistration streamReg = (StreamNotificationTopicRegistration)notifReg;
                streamReg.setLastEventTime(notificationEventTime);
            }
            for (TopicId topicId : topicIdsForNotification) {
                this.publishNotification(notification, topicId);
                LOG.debug("Notification {} has been published for TopicId {}", (Object)notification.getType(), (Object)topicId.getValue());
            }
        }
    }

    private void publishNotification(DOMNotification notification, TopicId topicId) {
        ContainerNode topicNotification = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)TOPIC_NOTIFICATION_ARG).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)TOPIC_ID_ARG, (Object)topicId)).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)EVENT_SOURCE_ARG, (Object)this.nodeId)).withChild((DataContainerChild)this.encapsulate(notification)).build();
        try {
            this.domPublish.putNotification((DOMNotification)new TopicDOMNotification(topicNotification));
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private AnyXmlNode encapsulate(DOMNotification body) {
        Document doc = XmlUtil.newDocument();
        Optional namespace = Optional.of((Object)PAYLOAD_ARG.getNodeType().getNamespace().toString());
        Element element = XmlUtil.createElement((Document)doc, (String)"payload", (Optional)namespace);
        DOMResult result = new DOMResult(element);
        SchemaContext context = this.getDOMMountPoint().getSchemaContext();
        SchemaPath schemaPath = body.getType();
        try {
            NetconfMessageTransformUtil.writeNormalizedNode((NormalizedNode)body.getBody(), (DOMResult)result, (SchemaPath)schemaPath, (SchemaContext)context);
            return (AnyXmlNode)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)PAYLOAD_ARG).withValue((Object)new DOMSource(element)).build();
        }
        catch (IOException | XMLStreamException e) {
            LOG.error("Unable to encapsulate notification.", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private List<SchemaPath> getMatchingNotifications(NotificationPattern notificationPattern) {
        String regex = Util.wildcardToRegex(notificationPattern.getValue());
        Pattern pattern = Pattern.compile(regex);
        List<SchemaPath> availableNotifications = this.getAvailableNotifications();
        if (availableNotifications == null || availableNotifications.isEmpty()) {
            return null;
        }
        return Util.expandQname(availableNotifications, pattern);
    }

    public void close() throws Exception {
        for (NotificationTopicRegistration streamReg : this.notificationTopicRegistrationList) {
            streamReg.close();
        }
    }

    public NodeKey getSourceNodeKey() {
        return this.getNode().getKey();
    }

    public List<SchemaPath> getAvailableNotifications() {
        ArrayList<SchemaPath> availNotifList = new ArrayList<SchemaPath>();
        availNotifList.add(ConnectionNotificationTopicRegistration.EVENT_SOURCE_STATUS_PATH);
        Set availableNotifications = this.getDOMMountPoint().getSchemaContext().getNotifications();
        for (NotificationDefinition nd : availableNotifications) {
            availNotifList.add(nd.getPath());
        }
        return availNotifList;
    }

    public Node getNode() {
        return this.node;
    }

    DOMMountPoint getDOMMountPoint() {
        return this.netconfMount;
    }

    MountPoint getMountPoint() {
        return this.mountPoint;
    }

    NetconfNode getNetconfNode() {
        return (NetconfNode)this.node.getAugmentation(NetconfNode.class);
    }
}

