/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.messagebus.eventsources.netconf;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.controller.md.sal.dom.api.DOMNotification;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationListener;
import org.opendaylight.controller.messagebus.eventsources.netconf.NotificationTopicRegistration;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.EventSourceStatus;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.EventSourceStatusNotification;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.EventSourceStatusNotificationBuilder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConnectionNotificationTopicRegistration
extends NotificationTopicRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionNotificationTopicRegistration.class);
    public static final SchemaPath EVENT_SOURCE_STATUS_PATH = SchemaPath.create((boolean)true, (QName[])new QName[]{QName.create((QName)EventSourceStatusNotification.QNAME, (String)"event-source-status")});
    private static final YangInstanceIdentifier.NodeIdentifier EVENT_SOURCE_STATUS_ARG = new YangInstanceIdentifier.NodeIdentifier(EventSourceStatusNotification.QNAME);
    private static final String XMLNS_ATTRIBUTE_KEY = "xmlns";
    private static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private final DOMNotificationListener domNotificationListener;
    private ConcurrentHashMap<SchemaPath, ArrayList<TopicId>> notificationTopicMap = new ConcurrentHashMap();

    public ConnectionNotificationTopicRegistration(String SourceName, DOMNotificationListener domNotificationListener) {
        super(NotificationTopicRegistration.NotificationSourceType.ConnectionStatusChange, SourceName, EVENT_SOURCE_STATUS_PATH.getLastComponent().getNamespace().toString());
        this.domNotificationListener = (DOMNotificationListener)Preconditions.checkNotNull((Object)domNotificationListener);
        LOG.info("Connection notification source has been initialized.");
        this.setActive(true);
        this.setReplaySupported(false);
    }

    @Override
    public void close() throws Exception {
        if (this.isActive()) {
            LOG.debug("Connection notification - publish Deactive");
            this.publishNotification(EventSourceStatus.Deactive);
            this.notificationTopicMap.clear();
            this.setActive(false);
        }
    }

    @Override
    void activateNotificationSource() {
        LOG.debug("Connection notification - publish Active");
        this.publishNotification(EventSourceStatus.Active);
    }

    @Override
    void deActivateNotificationSource() {
        LOG.debug("Connection notification - publish Inactive");
        this.publishNotification(EventSourceStatus.Inactive);
    }

    @Override
    void reActivateNotificationSource() {
        LOG.debug("Connection notification - reactivate - publish active");
        this.publishNotification(EventSourceStatus.Active);
    }

    @Override
    boolean registerNotificationTopic(SchemaPath notificationPath, TopicId topicId) {
        if (!this.checkNotificationPath(notificationPath)) {
            LOG.debug("Bad SchemaPath for notification try to register");
            return false;
        }
        ArrayList<Object> topicIds = this.getNotificationTopicIds(notificationPath);
        if (topicIds == null) {
            topicIds = new ArrayList();
            topicIds.add(topicId);
        } else if (!topicIds.contains(topicId)) {
            topicIds.add(topicId);
        }
        this.notificationTopicMap.put(notificationPath, topicIds);
        return true;
    }

    @Override
    ArrayList<TopicId> getNotificationTopicIds(SchemaPath notificationPath) {
        return this.notificationTopicMap.get(notificationPath);
    }

    @Override
    synchronized void unRegisterNotificationTopic(TopicId topicId) {
        ArrayList<SchemaPath> notificationPathToRemove = new ArrayList<SchemaPath>();
        for (SchemaPath notifKey : this.notificationTopicMap.keySet()) {
            ArrayList<TopicId> topicList = this.notificationTopicMap.get(notifKey);
            if (topicList == null) continue;
            topicList.remove(topicId);
            if (!topicList.isEmpty()) continue;
            notificationPathToRemove.add(notifKey);
        }
        for (SchemaPath notifKey : notificationPathToRemove) {
            this.notificationTopicMap.remove(notifKey);
        }
    }

    private void publishNotification(EventSourceStatus eventSourceStatus) {
        EventSourceStatusNotification notification = new EventSourceStatusNotificationBuilder().setStatus(eventSourceStatus).build();
        this.domNotificationListener.onNotification(this.createNotification(notification));
    }

    private DOMNotification createNotification(EventSourceStatusNotification notification) {
        final ContainerNode cn = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)EVENT_SOURCE_STATUS_ARG).withChild((DataContainerChild)this.encapsulate(notification)).build();
        DOMNotification dn = new DOMNotification(){

            public SchemaPath getType() {
                return EVENT_SOURCE_STATUS_PATH;
            }

            public ContainerNode getBody() {
                return cn;
            }
        };
        return dn;
    }

    private AnyXmlNode encapsulate(EventSourceStatusNotification notification) {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Can not create XML DocumentBuilder");
        }
        Document doc = docBuilder.newDocument();
        Optional namespace = Optional.of((Object)EVENT_SOURCE_STATUS_ARG.getNodeType().getNamespace().toString());
        Element rootElement = this.createElement(doc, "EventSourceStatusNotification", (Optional<String>)namespace);
        Element sourceElement = doc.createElement("status");
        sourceElement.appendChild(doc.createTextNode(notification.getStatus().name()));
        rootElement.appendChild(sourceElement);
        return (AnyXmlNode)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)EVENT_SOURCE_STATUS_ARG).withValue((Object)new DOMSource(rootElement)).build();
    }

    private Element createElement(Document document, String qName, Optional<String> namespaceURI) {
        if (namespaceURI.isPresent()) {
            Element element = document.createElementNS((String)namespaceURI.get(), qName);
            String name = XMLNS_ATTRIBUTE_KEY;
            if (element.getPrefix() != null) {
                name = name + ":" + element.getPrefix();
            }
            element.setAttributeNS(XMLNS_URI, name, (String)namespaceURI.get());
            return element;
        }
        return document.createElement(qName);
    }
}

