/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.messagebus.app.impl;

import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class Util {
    public static <T> Future<RpcResult<T>> resultRpcSuccessFor(T output) {
        RpcResult result = RpcResultBuilder.success(output).build();
        return Futures.immediateFuture((Object)result);
    }

    public static List<SchemaPath> expandQname(List<SchemaPath> list, Pattern pattern) {
        ArrayList<SchemaPath> matchingQnames = new ArrayList<SchemaPath>();
        for (SchemaPath notification : list) {
            String namespace = notification.getLastComponent().getNamespace().toString();
            if (!pattern.matcher(namespace).matches()) continue;
            matchingQnames.add(notification);
        }
        return matchingQnames;
    }

    public static String wildcardToRegex(String wildcard) {
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append('^');
        block5: for (char c : wildcard.toCharArray()) {
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append('.');
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }
}

