/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.messagebus.app.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.md.sal.binding.BindingAwareBrokerServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.BrokerServiceInterface;
import org.opendaylight.controller.config.yang.messagebus.app.impl.MessageBusAppImplModuleMXBean;
import org.opendaylight.controller.config.yang.messagebus.app.impl.MessageBusAppImplRuntimeRegistrator;
import org.opendaylight.controller.config.yang.messagebus.app.impl.NamespaceToStream;
import org.opendaylight.controller.config.yang.messagebus.spi.eventsourceregistry.EventSourceRegistryServiceInterface;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2015-02-03", name="messagebus-app-impl", namespace="urn:opendaylight:params:xml:ns:yang:controller:messagebus:app:impl")
public abstract class AbstractMessageBusAppImplModule
extends AbstractModule<AbstractMessageBusAppImplModule>
implements MessageBusAppImplModuleMXBean,
EventSourceRegistryServiceInterface,
RuntimeBeanRegistratorAwareModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageBusAppImplModule.class);
    public static final JmxAttribute namespaceToStreamJmxAttribute = new JmxAttribute("NamespaceToStream");
    private List<NamespaceToStream> namespaceToStream = new ArrayList<NamespaceToStream>();
    public static final JmxAttribute bindingBrokerJmxAttribute = new JmxAttribute("BindingBroker");
    private ObjectName bindingBroker;
    public static final JmxAttribute domBrokerJmxAttribute = new JmxAttribute("DomBroker");
    private ObjectName domBroker;
    private MessageBusAppImplRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;
    private BindingAwareBroker bindingBrokerDependency;
    private Broker domBrokerDependency;

    public AbstractMessageBusAppImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractMessageBusAppImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractMessageBusAppImplModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public MessageBusAppImplRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new MessageBusAppImplRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        this.dependencyResolver.validateDependency(BindingAwareBrokerServiceInterface.class, this.bindingBroker, bindingBrokerJmxAttribute);
        this.dependencyResolver.validateDependency(BrokerServiceInterface.class, this.domBroker, domBrokerJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final BindingAwareBroker getBindingBrokerDependency() {
        return this.bindingBrokerDependency;
    }

    protected final Broker getDomBrokerDependency() {
        return this.domBrokerDependency;
    }

    protected final void resolveDependencies() {
        this.domBrokerDependency = (Broker)this.dependencyResolver.resolveInstance(Broker.class, this.domBroker, domBrokerJmxAttribute);
        this.bindingBrokerDependency = (BindingAwareBroker)this.dependencyResolver.resolveInstance(BindingAwareBroker.class, this.bindingBroker, bindingBrokerJmxAttribute);
        if (this.namespaceToStream != null) {
            for (NamespaceToStream candidate : this.namespaceToStream) {
                candidate.injectDependencyResolver(this.dependencyResolver);
            }
        }
    }

    public boolean canReuseInstance(AbstractMessageBusAppImplModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractMessageBusAppImplModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.namespaceToStream, other.namespaceToStream)) {
            return false;
        }
        if (!Objects.deepEquals(this.bindingBroker, other.bindingBroker)) {
            return false;
        }
        if (this.bindingBroker != null && !this.dependencyResolver.canReuseDependency(this.bindingBroker, bindingBrokerJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.domBroker, other.domBroker)) {
            return false;
        }
        return this.domBroker == null || this.dependencyResolver.canReuseDependency(this.domBroker, domBrokerJmxAttribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMessageBusAppImplModule that = (AbstractMessageBusAppImplModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public List<NamespaceToStream> getNamespaceToStream() {
        return this.namespaceToStream;
    }

    @Override
    public void setNamespaceToStream(List<NamespaceToStream> namespaceToStream) {
        this.namespaceToStream = namespaceToStream;
    }

    @Override
    public ObjectName getBindingBroker() {
        return this.bindingBroker;
    }

    @Override
    @RequireInterface(value=BindingAwareBrokerServiceInterface.class)
    public void setBindingBroker(ObjectName bindingBroker) {
        this.bindingBroker = bindingBroker;
    }

    @Override
    public ObjectName getDomBroker() {
        return this.domBroker;
    }

    @Override
    @RequireInterface(value=BrokerServiceInterface.class)
    public void setDomBroker(ObjectName domBroker) {
        this.domBroker = domBroker;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

