/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.messagebus.eventsources.netconf;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPoint;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationListener;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.messagebus.eventsources.netconf.NetconfEventSource;
import org.opendaylight.controller.messagebus.eventsources.netconf.NotificationTopicRegistration;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscriptionInput;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamNotificationTopicRegistration
extends NotificationTopicRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(StreamNotificationTopicRegistration.class);
    private static final YangInstanceIdentifier.NodeIdentifier STREAM_QNAME = new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)CreateSubscriptionInput.QNAME, (String)"stream"));
    private static final SchemaPath CREATE_SUBSCRIPTION = SchemaPath.create((boolean)true, (QName[])new QName[]{QName.create((QName)CreateSubscriptionInput.QNAME, (String)"create-subscription")});
    private static final YangInstanceIdentifier.NodeIdentifier START_TIME_SUBSCRIPTION = new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)CreateSubscriptionInput.QNAME, (String)"startTime"));
    private final DOMMountPoint domMountPoint;
    private final String nodeId;
    private final NetconfEventSource netconfEventSource;
    private final Stream stream;
    private Date lastEventTime;
    private ConcurrentHashMap<SchemaPath, ListenerRegistration<NetconfEventSource>> notificationRegistrationMap = new ConcurrentHashMap();
    private ConcurrentHashMap<SchemaPath, ArrayList<TopicId>> notificationTopicMap = new ConcurrentHashMap();

    public StreamNotificationTopicRegistration(Stream stream, String notificationPrefix, NetconfEventSource netconfEventSource) {
        super(NotificationTopicRegistration.NotificationSourceType.NetconfDeviceStream, stream.getName().getValue(), notificationPrefix);
        this.domMountPoint = netconfEventSource.getDOMMountPoint();
        this.nodeId = netconfEventSource.getNode().getNodeId().getValue().toString();
        this.netconfEventSource = netconfEventSource;
        this.stream = stream;
        this.lastEventTime = null;
        this.setReplaySupported(this.stream.isReplaySupport());
        this.setActive(false);
        LOG.info("StreamNotificationTopicRegistration initialized for {}", (Object)this.getStreamName());
    }

    @Override
    void activateNotificationSource() {
        if (!this.isActive()) {
            LOG.info("Stream {} is not active on node {}. Will subscribe.", (Object)this.getStreamName(), (Object)this.nodeId);
            ContainerNode input = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(CreateSubscriptionInput.QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)STREAM_QNAME, (Object)this.getStreamName())).build();
            CheckedFuture csFuture = ((DOMRpcService)this.domMountPoint.getService(DOMRpcService.class).get()).invokeRpc(CREATE_SUBSCRIPTION, (NormalizedNode)input);
            try {
                csFuture.checkedGet();
                this.setActive(true);
            }
            catch (DOMRpcException e) {
                LOG.warn("Can not subscribe stream {} on node {}", (Object)this.getSourceName(), (Object)this.nodeId);
                this.setActive(false);
                return;
            }
        } else {
            LOG.info("Stream {} is now active on node {}", (Object)this.getStreamName(), (Object)this.nodeId);
        }
    }

    @Override
    void reActivateNotificationSource() {
        if (this.isActive()) {
            LOG.info("Stream {} is reactivating on node {}.", (Object)this.getStreamName(), (Object)this.nodeId);
            DataContainerNodeAttrBuilder inputBuilder = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(CreateSubscriptionInput.QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)STREAM_QNAME, (Object)this.getStreamName()));
            if (this.isReplaySupported() && this.getLastEventTime() != null) {
                inputBuilder.withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)START_TIME_SUBSCRIPTION, this.getLastEventTime()));
            }
            ContainerNode input = (ContainerNode)inputBuilder.build();
            CheckedFuture csFuture = ((DOMRpcService)this.domMountPoint.getService(DOMRpcService.class).get()).invokeRpc(CREATE_SUBSCRIPTION, (NormalizedNode)input);
            try {
                csFuture.checkedGet();
                this.setActive(true);
            }
            catch (DOMRpcException e) {
                LOG.warn("Can not resubscribe stream {} on node {}", (Object)this.getSourceName(), (Object)this.nodeId);
                this.setActive(false);
                return;
            }
        }
    }

    @Override
    void deActivateNotificationSource() {
    }

    private void closeStream() {
        if (this.isActive()) {
            for (ListenerRegistration<NetconfEventSource> reg : this.notificationRegistrationMap.values()) {
                reg.close();
            }
            this.notificationRegistrationMap.clear();
            this.notificationTopicMap.clear();
            this.setActive(false);
        }
    }

    private String getStreamName() {
        return this.getSourceName();
    }

    @Override
    ArrayList<TopicId> getNotificationTopicIds(SchemaPath notificationPath) {
        return this.notificationTopicMap.get(notificationPath);
    }

    @Override
    boolean registerNotificationTopic(SchemaPath notificationPath, TopicId topicId) {
        if (!this.checkNotificationPath(notificationPath)) {
            LOG.debug("Bad SchemaPath for notification try to register");
            return false;
        }
        Optional notifyService = this.domMountPoint.getService(DOMNotificationService.class);
        if (!notifyService.isPresent()) {
            LOG.debug("DOMNotificationService is not present");
            return false;
        }
        this.activateNotificationSource();
        if (!this.isActive()) {
            LOG.warn("Stream {} is not active, listener for notification {} is not registered.", (Object)this.getStreamName(), (Object)notificationPath.toString());
            return false;
        }
        ListenerRegistration registration = ((DOMNotificationService)notifyService.get()).registerNotificationListener((DOMNotificationListener)this.netconfEventSource, new SchemaPath[]{notificationPath});
        this.notificationRegistrationMap.put(notificationPath, (ListenerRegistration<NetconfEventSource>)registration);
        ArrayList<Object> topicIds = this.getNotificationTopicIds(notificationPath);
        if (topicIds == null) {
            topicIds = new ArrayList();
            topicIds.add(topicId);
        } else if (!topicIds.contains(topicId)) {
            topicIds.add(topicId);
        }
        this.notificationTopicMap.put(notificationPath, topicIds);
        return true;
    }

    @Override
    synchronized void unRegisterNotificationTopic(TopicId topicId) {
        ArrayList<SchemaPath> notificationPathToRemove = new ArrayList<SchemaPath>();
        for (SchemaPath notifKey : this.notificationTopicMap.keySet()) {
            ArrayList<TopicId> topicList = this.notificationTopicMap.get(notifKey);
            if (topicList == null) continue;
            topicList.remove(topicId);
            if (!topicList.isEmpty()) continue;
            notificationPathToRemove.add(notifKey);
        }
        for (SchemaPath notifKey : notificationPathToRemove) {
            this.notificationTopicMap.remove(notifKey);
            ListenerRegistration<NetconfEventSource> reg = this.notificationRegistrationMap.remove(notifKey);
            if (reg == null) continue;
            reg.close();
        }
    }

    Optional<Date> getLastEventTime() {
        return Optional.fromNullable((Object)this.lastEventTime);
    }

    void setLastEventTime(Date lastEventTime) {
        this.lastEventTime = lastEventTime;
    }

    @Override
    public void close() throws Exception {
        this.closeStream();
    }
}

