/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.messagebus.eventsources.netconf;

import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NotificationTopicRegistration
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationTopicRegistration.class);
    private boolean active;
    private final NotificationSourceType notificationSourceType;
    private final String sourceName;
    private final String notificationUrnPrefix;
    private boolean replaySupported;

    protected NotificationTopicRegistration(NotificationSourceType notificationSourceType, String sourceName, String notificationUrnPrefix) {
        this.notificationSourceType = notificationSourceType;
        this.sourceName = sourceName;
        this.notificationUrnPrefix = notificationUrnPrefix;
        this.active = false;
        this.setReplaySupported(false);
    }

    public boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        this.active = active;
    }

    public NotificationSourceType getNotificationSourceType() {
        return this.notificationSourceType;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getNotificationUrnPrefix() {
        return this.notificationUrnPrefix;
    }

    public boolean checkNotificationPath(SchemaPath notificationPath) {
        if (notificationPath == null) {
            return false;
        }
        String nameSpace = notificationPath.getLastComponent().toString();
        LOG.debug("CheckNotification - name space {} - NotificationUrnPrefix {}", (Object)nameSpace, (Object)this.getNotificationUrnPrefix());
        return nameSpace.startsWith(this.getNotificationUrnPrefix());
    }

    abstract void activateNotificationSource();

    abstract void deActivateNotificationSource();

    abstract void reActivateNotificationSource();

    abstract boolean registerNotificationTopic(SchemaPath var1, TopicId var2);

    abstract void unRegisterNotificationTopic(TopicId var1);

    abstract ArrayList<TopicId> getNotificationTopicIds(SchemaPath var1);

    public boolean isReplaySupported() {
        return this.replaySupported;
    }

    protected void setReplaySupported(boolean replaySupported) {
        this.replaySupported = replaySupported;
    }

    public static enum NotificationSourceType {
        NetconfDeviceStream,
        ConnectionStatusChange;

    }
}

