/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.messagebus.eventsources.netconf;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import org.opendaylight.controller.md.sal.binding.api.MountPoint;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPoint;
import org.opendaylight.controller.messagebus.eventsources.netconf.NetconfEventSource;
import org.opendaylight.controller.messagebus.eventsources.netconf.NetconfEventSourceManager;
import org.opendaylight.controller.messagebus.spi.EventSource;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.network.topology.topology.topology.types.TopologyNetconf;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfEventSourceRegistration
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfEventSourceRegistration.class);
    private static final YangInstanceIdentifier NETCONF_DEVICE_DOM_PATH = YangInstanceIdentifier.builder().node(NetworkTopology.QNAME).node(Topology.QNAME).nodeWithKey(Topology.QNAME, QName.create((QName)Topology.QNAME, (String)"topology-id"), (Object)TopologyNetconf.QNAME.getLocalName()).node(Node.QNAME).build();
    private static final QName NODE_ID_QNAME = QName.create((QName)Node.QNAME, (String)"node-id");
    private static final String NotificationCapabilityPrefix = "(urn:ietf:params:xml:ns:netconf:notification";
    private final Node node;
    private final InstanceIdentifier<?> instanceIdent;
    private final NetconfEventSourceManager netconfEventSourceManager;
    private NetconfNodeFields.ConnectionStatus currentNetconfConnStatus;
    private EventSourceRegistration<NetconfEventSource> eventSourceRegistration;

    public static NetconfEventSourceRegistration create(InstanceIdentifier<?> instanceIdent, Node node, NetconfEventSourceManager netconfEventSourceManager) {
        Preconditions.checkNotNull(instanceIdent);
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)netconfEventSourceManager);
        if (!NetconfEventSourceRegistration.isEventSource(node)) {
            return null;
        }
        NetconfEventSourceRegistration nesr = new NetconfEventSourceRegistration(instanceIdent, node, netconfEventSourceManager);
        nesr.updateStatus();
        LOG.debug("NetconfEventSourceRegistration for node {} has been initialized...", (Object)node.getNodeId().getValue());
        return nesr;
    }

    private static boolean isEventSource(Node node) {
        NetconfNode netconfNode = (NetconfNode)node.getAugmentation(NetconfNode.class);
        if (netconfNode == null) {
            return false;
        }
        if (netconfNode.getAvailableCapabilities() == null) {
            return false;
        }
        List capabilities = netconfNode.getAvailableCapabilities().getAvailableCapability();
        if (capabilities == null || capabilities.isEmpty()) {
            return false;
        }
        for (String capability : netconfNode.getAvailableCapabilities().getAvailableCapability()) {
            if (!capability.startsWith(NotificationCapabilityPrefix)) continue;
            return true;
        }
        return false;
    }

    private NetconfEventSourceRegistration(InstanceIdentifier<?> instanceIdent, Node node, NetconfEventSourceManager netconfEventSourceManager) {
        this.instanceIdent = instanceIdent;
        this.node = node;
        this.netconfEventSourceManager = netconfEventSourceManager;
        this.eventSourceRegistration = null;
    }

    public Node getNode() {
        return this.node;
    }

    Optional<EventSourceRegistration<NetconfEventSource>> getEventSourceRegistration() {
        return Optional.fromNullable(this.eventSourceRegistration);
    }

    NetconfNode getNetconfNode() {
        return (NetconfNode)this.node.getAugmentation(NetconfNode.class);
    }

    void updateStatus() {
        NetconfNodeFields.ConnectionStatus netconfConnStatus = this.getNetconfNode().getConnectionStatus();
        LOG.info("Change status on node {}, new status is {}", (Object)this.node.getNodeId().getValue(), (Object)netconfConnStatus);
        if (netconfConnStatus.equals((Object)this.currentNetconfConnStatus)) {
            return;
        }
        this.changeStatus(netconfConnStatus);
    }

    private boolean checkConnectionStatusType(NetconfNodeFields.ConnectionStatus status) {
        return status == NetconfNodeFields.ConnectionStatus.Connected || status == NetconfNodeFields.ConnectionStatus.Connecting || status == NetconfNodeFields.ConnectionStatus.UnableToConnect;
    }

    private void changeStatus(NetconfNodeFields.ConnectionStatus newStatus) {
        Preconditions.checkNotNull((Object)newStatus);
        if (!this.checkConnectionStatusType(newStatus)) {
            throw new IllegalStateException("Unknown new Netconf Connection Status");
        }
        if (this.currentNetconfConnStatus == null) {
            if (newStatus == NetconfNodeFields.ConnectionStatus.Connected) {
                this.registrationEventSource();
            }
        } else if (this.currentNetconfConnStatus == NetconfNodeFields.ConnectionStatus.Connecting) {
            if (newStatus == NetconfNodeFields.ConnectionStatus.Connected) {
                if (this.eventSourceRegistration == null) {
                    this.registrationEventSource();
                } else {
                    ((NetconfEventSource)this.eventSourceRegistration.getInstance()).reActivateStreams();
                }
            }
        } else if (this.currentNetconfConnStatus == NetconfNodeFields.ConnectionStatus.Connected) {
            if (newStatus == NetconfNodeFields.ConnectionStatus.Connecting || newStatus == NetconfNodeFields.ConnectionStatus.UnableToConnect) {
                ((NetconfEventSource)this.eventSourceRegistration.getInstance()).deActivateStreams();
            }
        } else if (this.currentNetconfConnStatus == NetconfNodeFields.ConnectionStatus.UnableToConnect) {
            if (newStatus == NetconfNodeFields.ConnectionStatus.Connected) {
                if (this.eventSourceRegistration == null) {
                    this.registrationEventSource();
                } else {
                    ((NetconfEventSource)this.eventSourceRegistration.getInstance()).reActivateStreams();
                }
            }
        } else {
            throw new IllegalStateException("Unknown current Netconf Connection Status");
        }
        this.currentNetconfConnStatus = newStatus;
    }

    private void registrationEventSource() {
        Optional mountPoint = this.netconfEventSourceManager.getMountPointService().getMountPoint(this.instanceIdent);
        Optional domMountPoint = this.netconfEventSourceManager.getDomMounts().getMountPoint(this.domMountPath(this.node.getNodeId()));
        EventSourceRegistration registration = null;
        if (domMountPoint.isPresent() && mountPoint.isPresent()) {
            NetconfEventSource netconfEventSource = new NetconfEventSource(this.node, this.netconfEventSourceManager.getStreamMap(), (DOMMountPoint)domMountPoint.get(), (MountPoint)mountPoint.get(), this.netconfEventSourceManager.getPublishService());
            registration = this.netconfEventSourceManager.getEventSourceRegistry().registerEventSource((EventSource)netconfEventSource);
            LOG.info("Event source {} has been registered", (Object)this.node.getNodeId().getValue());
        }
        this.eventSourceRegistration = registration;
    }

    private YangInstanceIdentifier domMountPath(NodeId nodeId) {
        return YangInstanceIdentifier.builder((YangInstanceIdentifier)NETCONF_DEVICE_DOM_PATH).nodeWithKey(Node.QNAME, NODE_ID_QNAME, (Object)nodeId.getValue()).build();
    }

    private void closeEventSourceRegistration() {
        if (this.getEventSourceRegistration().isPresent()) {
            ((EventSourceRegistration)this.getEventSourceRegistration().get()).close();
        }
    }

    @Override
    public void close() {
        this.closeEventSourceRegistration();
    }
}

