/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.messagebus.eventsources.netconf;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.config.yang.messagebus.app.impl.NamespaceToStream;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.binding.api.MountPointService;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPointService;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationPublishService;
import org.opendaylight.controller.messagebus.eventsources.netconf.NetconfEventSourceRegistration;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.network.topology.topology.topology.types.TopologyNetconf;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfEventSourceManager
implements DataChangeListener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfEventSourceManager.class);
    private static final TopologyKey NETCONF_TOPOLOGY_KEY = new TopologyKey(new TopologyId(TopologyNetconf.QNAME.getLocalName()));
    private static final InstanceIdentifier<Node> NETCONF_DEVICE_PATH = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Identifier)NETCONF_TOPOLOGY_KEY).child(Node.class);
    private final Map<String, String> streamMap;
    private final ConcurrentHashMap<InstanceIdentifier<?>, NetconfEventSourceRegistration> registrationMap = new ConcurrentHashMap();
    private final DOMNotificationPublishService publishService;
    private final DOMMountPointService domMounts;
    private final MountPointService mountPointService;
    private ListenerRegistration<DataChangeListener> listenerRegistration;
    private final EventSourceRegistry eventSourceRegistry;

    public static NetconfEventSourceManager create(DataBroker dataBroker, DOMNotificationPublishService domPublish, DOMMountPointService domMount, MountPointService bindingMount, EventSourceRegistry eventSourceRegistry, List<NamespaceToStream> namespaceMapping) {
        NetconfEventSourceManager eventSourceManager = new NetconfEventSourceManager(domPublish, domMount, bindingMount, eventSourceRegistry, namespaceMapping);
        eventSourceManager.initialize(dataBroker);
        return eventSourceManager;
    }

    private NetconfEventSourceManager(DOMNotificationPublishService domPublish, DOMMountPointService domMount, MountPointService bindingMount, EventSourceRegistry eventSourceRegistry, List<NamespaceToStream> namespaceMapping) {
        Preconditions.checkNotNull((Object)domPublish);
        Preconditions.checkNotNull((Object)domMount);
        Preconditions.checkNotNull((Object)bindingMount);
        Preconditions.checkNotNull((Object)eventSourceRegistry);
        Preconditions.checkNotNull(namespaceMapping);
        this.streamMap = this.namespaceToStreamMapping(namespaceMapping);
        this.domMounts = domMount;
        this.mountPointService = bindingMount;
        this.publishService = domPublish;
        this.eventSourceRegistry = eventSourceRegistry;
    }

    private void initialize(DataBroker dataBroker) {
        Preconditions.checkNotNull((Object)dataBroker);
        this.listenerRegistration = dataBroker.registerDataChangeListener(LogicalDatastoreType.OPERATIONAL, NETCONF_DEVICE_PATH, (DataChangeListener)this, AsyncDataBroker.DataChangeScope.SUBTREE);
        LOG.info("NetconfEventSourceManager initialized.");
    }

    private Map<String, String> namespaceToStreamMapping(List<NamespaceToStream> namespaceMapping) {
        HashMap<String, String> streamMap = new HashMap<String, String>(namespaceMapping.size());
        for (NamespaceToStream nToS : namespaceMapping) {
            streamMap.put(nToS.getUrnPrefix(), nToS.getStreamName());
        }
        return streamMap;
    }

    public void onDataChanged(AsyncDataChangeEvent<InstanceIdentifier<?>, DataObject> event) {
        LOG.debug("[DataChangeEvent<InstanceIdentifier<?>, DataObject>: {}]", event);
        for (Map.Entry changeEntry : event.getCreatedData().entrySet()) {
            if (!(changeEntry.getValue() instanceof Node)) continue;
            this.nodeCreated((InstanceIdentifier)changeEntry.getKey(), (Node)changeEntry.getValue());
        }
        for (Map.Entry changeEntry : event.getUpdatedData().entrySet()) {
            if (!(changeEntry.getValue() instanceof Node)) continue;
            this.nodeUpdated((InstanceIdentifier)changeEntry.getKey(), (Node)changeEntry.getValue());
        }
        for (InstanceIdentifier removePath : event.getRemovedPaths()) {
            DataObject removeObject = (DataObject)event.getOriginalData().get(removePath);
            if (!(removeObject instanceof Node)) continue;
            this.nodeRemoved(removePath);
        }
    }

    private void nodeCreated(InstanceIdentifier<?> key, Node node) {
        NetconfEventSourceRegistration nesrOld;
        Preconditions.checkNotNull(key);
        if (!this.validateNode(node)) {
            LOG.warn("NodeCreated event : Node [{}] is null or not valid.", (Object)key.toString());
            return;
        }
        LOG.info("Netconf event source [{}] is creating...", (Object)key.toString());
        NetconfEventSourceRegistration nesr = NetconfEventSourceRegistration.create(key, node, this);
        if (nesr != null && (nesrOld = this.registrationMap.put(key, nesr)) != null) {
            nesrOld.close();
        }
    }

    private void nodeUpdated(InstanceIdentifier<?> key, Node node) {
        Preconditions.checkNotNull(key);
        if (!this.validateNode(node)) {
            LOG.warn("NodeUpdated event : Node [{}] is null or not valid.", (Object)key.toString());
            return;
        }
        LOG.info("Netconf event source [{}] is updating...", (Object)key.toString());
        NetconfEventSourceRegistration nesr = this.registrationMap.get(key);
        if (nesr != null) {
            nesr.updateStatus();
        } else {
            this.nodeCreated(key, node);
        }
    }

    private void nodeRemoved(InstanceIdentifier<?> key) {
        Preconditions.checkNotNull(key);
        LOG.info("Netconf event source [{}] is removing...", (Object)key.toString());
        NetconfEventSourceRegistration nesr = this.registrationMap.remove(key);
        if (nesr != null) {
            nesr.close();
        }
    }

    private boolean validateNode(Node node) {
        if (node == null) {
            return false;
        }
        return this.isNetconfNode(node);
    }

    Map<String, String> getStreamMap() {
        return this.streamMap;
    }

    DOMNotificationPublishService getPublishService() {
        return this.publishService;
    }

    DOMMountPointService getDomMounts() {
        return this.domMounts;
    }

    EventSourceRegistry getEventSourceRegistry() {
        return this.eventSourceRegistry;
    }

    MountPointService getMountPointService() {
        return this.mountPointService;
    }

    private boolean isNetconfNode(Node node) {
        return node.getAugmentation(NetconfNode.class) != null;
    }

    @Override
    public void close() {
        this.listenerRegistration.close();
        for (NetconfEventSourceRegistration reg : this.registrationMap.values()) {
            reg.close();
        }
        this.registrationMap.clear();
    }
}

