package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream
 *
 */
public class NamespaceToStreamBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream> {

    private NamespaceToStreamKey _key;
    private java.lang.String _streamName;
    private java.lang.String _urnPrefix;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>> augmentation = Collections.emptyMap();

    public NamespaceToStreamBuilder() {
    }

    public NamespaceToStreamBuilder(NamespaceToStream base) {
        if (base.getKey() == null) {
            this._key = new NamespaceToStreamKey(
                base.getUrnPrefix()
            );
            this._urnPrefix = base.getUrnPrefix();
        } else {
            this._key = base.getKey();
            this._urnPrefix = _key.getUrnPrefix();
        }
        this._streamName = base.getStreamName();
        if (base instanceof NamespaceToStreamImpl) {
            NamespaceToStreamImpl impl = (NamespaceToStreamImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public NamespaceToStreamKey getKey() {
        return _key;
    }
    
    public java.lang.String getStreamName() {
        return _streamName;
    }
    
    public java.lang.String getUrnPrefix() {
        return _urnPrefix;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public NamespaceToStreamBuilder setKey(NamespaceToStreamKey value) {
        this._key = value;
        return this;
    }
    
    public NamespaceToStreamBuilder setStreamName(java.lang.String value) {
        this._streamName = value;
        return this;
    }
    
    public NamespaceToStreamBuilder setUrnPrefix(java.lang.String value) {
        this._urnPrefix = value;
        return this;
    }
    
    public NamespaceToStreamBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public NamespaceToStreamBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NamespaceToStream build() {
        return new NamespaceToStreamImpl(this);
    }

    private static final class NamespaceToStreamImpl implements NamespaceToStream {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream.class;
        }

        private final NamespaceToStreamKey _key;
        private final java.lang.String _streamName;
        private final java.lang.String _urnPrefix;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>> augmentation = Collections.emptyMap();

        private NamespaceToStreamImpl(NamespaceToStreamBuilder base) {
            if (base.getKey() == null) {
                this._key = new NamespaceToStreamKey(
                    base.getUrnPrefix()
                );
                this._urnPrefix = base.getUrnPrefix();
            } else {
                this._key = base.getKey();
                this._urnPrefix = _key.getUrnPrefix();
            }
            this._streamName = base.getStreamName();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public NamespaceToStreamKey getKey() {
            return _key;
        }
        
        @Override
        public java.lang.String getStreamName() {
            return _streamName;
        }
        
        @Override
        public java.lang.String getUrnPrefix() {
            return _urnPrefix;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_key == null) ? 0 : _key.hashCode());
            result = prime * result + ((_streamName == null) ? 0 : _streamName.hashCode());
            result = prime * result + ((_urnPrefix == null) ? 0 : _urnPrefix.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream)obj;
            if (_key == null) {
                if (other.getKey() != null) {
                    return false;
                }
            } else if(!_key.equals(other.getKey())) {
                return false;
            }
            if (_streamName == null) {
                if (other.getStreamName() != null) {
                    return false;
                }
            } else if(!_streamName.equals(other.getStreamName())) {
                return false;
            }
            if (_urnPrefix == null) {
                if (other.getUrnPrefix() != null) {
                    return false;
                }
            } else if(!_urnPrefix.equals(other.getUrnPrefix())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NamespaceToStreamImpl otherImpl = (NamespaceToStreamImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.messagebus.app.impl.rev150203.modules.module.configuration.messagebus.app.impl.NamespaceToStream>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("NamespaceToStream [");
            boolean first = true;
        
            if (_key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(_key);
             }
            if (_streamName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_streamName=");
                builder.append(_streamName);
             }
            if (_urnPrefix != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_urnPrefix=");
                builder.append(_urnPrefix);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
