/*
 * Copyright (c) 2013 Cisco Systems, Inc. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */

/**
 * Generated file

 * Generated from: yang module name: config-test  yang module local name: testing
 * Generated by: org.opendaylight.controller.config.yangjmxgenerator.plugin.JMXGenerator
 * Generated at: Fri Sep 27 14:06:33 CEST 2013
 *
 * Do not modify this file unless it is present under src/main directory
 */
package org.opendaylight.controller.config.yang.logback.config;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.slf4j.LoggerFactory;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.status.StatusBase;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;

public class LogbackStatusListener implements StatusListener, LogbackRuntimeMXBean, Closeable {

    private final List<StatusTO> receivedStatuses;
    private final LogbackRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;
    private LogbackRuntimeRegistration reg;

    public LogbackStatusListener(LogbackRuntimeRegistrator rootRuntimeBeanRegistratorWrapper) {
        receivedStatuses = new ArrayList<>();
        this.rootRuntimeBeanRegistratorWrapper = rootRuntimeBeanRegistratorWrapper;
    }

    @Override
    public synchronized List<StatusTO> getStatusTO() {
        return Collections.unmodifiableList(receivedStatuses);
    }

    @Override
    public synchronized void reset() {
        receivedStatuses.clear();
    }

    public LogbackRuntimeRegistration register() {
        reg = registerToJMX(rootRuntimeBeanRegistratorWrapper);
        registerToLogback();
        return reg;
    }

    private LogbackRuntimeRegistration registerToJMX(LogbackRuntimeRegistrator rootRuntimeBeanRegistratorWrapper) {
        return rootRuntimeBeanRegistratorWrapper.register(this);
    }

    private synchronized void registerToLogback() {
        LoggerContext context = (LoggerContext) LoggerFactory.getILoggerFactory();
        final StatusManager statusManager = context.getStatusManager();

        statusManager.remove(this);
        reset();

        statusManager.add(this);
        addInitialStatuses(statusManager);
    }

    private void addInitialStatuses(StatusManager statusManager) {
        for (ch.qos.logback.core.status.Status status : statusManager.getCopyOfStatusList()) {
            addStatusEvent(status);
        }
    }

    @Override
    public synchronized void addStatusEvent(ch.qos.logback.core.status.Status status) {
        receivedStatuses.add(transformStatus(status));
    }

    private StatusTO transformStatus(ch.qos.logback.core.status.Status status) {
        StatusTO transformed = new StatusTO();

        transformed.setDate(status.getDate());
        transformed.setLevel(transformStatusLevel(status.getLevel()));
        transformed.setMessage(status.getMessage());

        return transformed;
    }

    private String transformStatusLevel(int status) {
        switch (status) {
        case StatusBase.INFO:
            return "INFO";
        case StatusBase.WARN:
            return "WARN";
        case StatusBase.ERROR:
            return "ERROR";
        default:
            throw new IllegalStateException("Unknown status level " + status);
        }
    }

    @Override
    public void close() throws IOException {
        if (reg != null)
            reg.close();
        unregisterFromLogback();
    }

    private void unregisterFromLogback() {
        LoggerContext context = (LoggerContext) LoggerFactory.getILoggerFactory();
        final StatusManager statusManager = context.getStatusManager();
        statusManager.remove(this);
    }
}
