/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.hosttracker.hostAware;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Host;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.packet.address.DataLinkAddress;
import org.opendaylight.controller.sal.packet.address.EthernetAddress;

@XmlRootElement(name="host")
@XmlAccessorType(value=XmlAccessType.NONE)
public class HostNodeConnector
extends Host {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private NodeConnector nodeConnector;
    @XmlElement
    private short vlan;
    @XmlElement
    private boolean staticHost;
    private transient short arpSendCountDown;

    private HostNodeConnector() {
    }

    public HostNodeConnector(InetAddress ip) throws ConstructionException {
        this(ip, null);
    }

    public HostNodeConnector(InetAddress ip, NodeConnector nc) throws ConstructionException {
        this(new EthernetAddress(new byte[]{0, 0, 0, 0, 0, 0}), ip, nc, 0);
    }

    public HostNodeConnector(byte[] mac, InetAddress ip, NodeConnector nc, short vlan) throws ConstructionException {
        this(new EthernetAddress((byte[])mac.clone()), ip, nc, vlan);
    }

    public HostNodeConnector(EthernetAddress eaddr, InetAddress naddr, NodeConnector nc, short vlan) throws ConstructionException {
        super((DataLinkAddress)eaddr, naddr);
        this.nodeConnector = nc;
        this.vlan = vlan;
    }

    public NodeConnector getnodeConnector() {
        return this.nodeConnector;
    }

    public Node getnodeconnectorNode() {
        return this.nodeConnector.getNode();
    }

    public Long getnodeconnectornodeId() {
        return (Long)this.nodeConnector.getNode().getID();
    }

    public Short getnodeconnectorportId() {
        return (Short)this.nodeConnector.getID();
    }

    public byte[] getDataLayerAddressBytes() {
        byte[] macaddr = null;
        if (this.getDataLayerAddress() instanceof EthernetAddress) {
            EthernetAddress e = (EthernetAddress)this.getDataLayerAddress();
            macaddr = e.getValue();
        }
        return macaddr;
    }

    public short getVlan() {
        return this.vlan;
    }

    public boolean isStaticHost() {
        return this.staticHost;
    }

    public HostNodeConnector setStaticHost(boolean statically_learned) {
        this.staticHost = statically_learned;
        return this;
    }

    public HostNodeConnector initArpSendCountDown() {
        this.arpSendCountDown = (short)24;
        return this;
    }

    public short getArpSendCountDown() {
        return this.arpSendCountDown;
    }

    public HostNodeConnector setArpSendCountDown(short cntdown) {
        this.arpSendCountDown = cntdown;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.nodeConnector == null ? 0 : this.nodeConnector.hashCode());
        result = 31 * result + (this.staticHost ? 1231 : 1237);
        result = 31 * result + this.vlan;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HostNodeConnector other = (HostNodeConnector)((Object)obj);
        if (this.nodeConnector == null ? other.nodeConnector != null : !this.nodeConnector.equals((Object)other.nodeConnector)) {
            return false;
        }
        if (this.staticHost != other.staticHost) {
            return false;
        }
        return this.vlan == other.vlan;
    }

    public boolean equalsByIP(InetAddress networkAddress) {
        return this.getNetworkAddress().equals(networkAddress);
    }

    public boolean isRewriteEnabled() {
        byte[] emptyArray = new byte[]{0, 0, 0, 0, 0, 0};
        byte[] macaddr = null;
        if (this.getDataLayerAddress() instanceof EthernetAddress) {
            EthernetAddress e = (EthernetAddress)this.getDataLayerAddress();
            macaddr = e.getValue();
        }
        if (macaddr == null) {
            return false;
        }
        return !Arrays.equals(emptyArray, macaddr);
    }

    public String toString() {
        return "HostNodeConnector[" + ReflectionToStringBuilder.toString((Object)((Object)this)) + "]";
    }

    public boolean isV4Host() {
        return this.getNetworkAddress() instanceof Inet4Address;
    }

    public boolean isV6Host() {
        return this.getNetworkAddress() instanceof Inet6Address;
    }

    public String toJson() {
        return "{\"host\":\"" + super.toString() + "\", " + "\"vlan\":\"" + String.valueOf(this.vlan) + "\",\"NodeConnector\":\"" + this.nodeConnector.toString() + "\"," + "\"static\":\"" + String.valueOf(this.isStaticHost()) + "\"}";
    }
}

