/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.hosttracker;

import org.opendaylight.controller.sal.core.NodeConnector;

public class SwitchPort {
    private final NodeConnector port;
    private final ErrorStatus errorStatus;

    public SwitchPort(NodeConnector port, ErrorStatus errorStatus) {
        this.port = port;
        this.errorStatus = errorStatus;
    }

    public SwitchPort(NodeConnector port) {
        this.port = port;
        this.errorStatus = null;
    }

    public NodeConnector getPort() {
        return this.port;
    }

    public ErrorStatus getErrorStatus() {
        return this.errorStatus;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.errorStatus == null ? 0 : this.errorStatus.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwitchPort other = (SwitchPort)obj;
        if (this.errorStatus != other.errorStatus) {
            return false;
        }
        return !(this.port == null ? other.port != null : !this.port.equals((Object)other.port));
    }

    public String toString() {
        return "SwitchPort [port=" + this.port + ", errorStatus=" + (Object)((Object)this.errorStatus) + "]";
    }

    public static enum ErrorStatus {
        DUPLICATE_DEVICE("duplicate-device");

        private String value;

        private ErrorStatus(String v) {
            this.value = v;
        }

        public String toString() {
            return this.value;
        }

        public static ErrorStatus fromString(String str) {
            for (ErrorStatus m : ErrorStatus.values()) {
                if (!m.value.equals(str)) continue;
                return m;
            }
            return null;
        }
    }
}

