/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.hosttracker;

import java.net.InetAddress;
import java.util.Date;
import org.opendaylight.controller.hosttracker.hostAware.HostNodeConnector;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.utils.NetUtils;

public class Entity
implements Comparable<Entity> {
    protected static int ACTIVITY_TIMEOUT = 30000;
    protected long macAddress;
    protected Integer ipv4Address;
    protected Short vlan;
    NodeConnector port;
    protected Date lastSeenTimestamp;
    protected Date activeSince;
    private int hashCode = 0;

    public Entity(long macAddress, Short vlan, Integer ipv4Address, NodeConnector port, Date lastSeenTimestamp) {
        this.macAddress = macAddress;
        this.ipv4Address = ipv4Address;
        this.vlan = vlan;
        this.port = port;
        this.lastSeenTimestamp = lastSeenTimestamp;
        this.activeSince = lastSeenTimestamp;
    }

    public long getMacAddress() {
        return this.macAddress;
    }

    public Integer getIpv4Address() {
        return this.ipv4Address;
    }

    public Short getVlan() {
        return this.vlan;
    }

    public NodeConnector getPort() {
        return this.port;
    }

    public boolean hasSwitchPort() {
        return this.port != null;
    }

    public Date getLastSeenTimestamp() {
        return this.lastSeenTimestamp;
    }

    public void setLastSeenTimestamp(Date lastSeenTimestamp) {
        if (this.activeSince == null || this.activeSince.getTime() + (long)ACTIVITY_TIMEOUT < lastSeenTimestamp.getTime()) {
            this.activeSince = lastSeenTimestamp;
        }
        this.lastSeenTimestamp = lastSeenTimestamp;
    }

    public Date getActiveSince() {
        return this.activeSince;
    }

    public void setActiveSince(Date activeSince) {
        this.activeSince = activeSince;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prime = 31;
        this.hashCode = 1;
        this.hashCode = 31 * this.hashCode + (this.ipv4Address == null ? 0 : this.ipv4Address.hashCode());
        this.hashCode = 31 * this.hashCode + (int)(this.macAddress ^ this.macAddress >>> 32);
        this.hashCode = 31 * this.hashCode + (this.port == null ? 0 : this.port.hashCode());
        this.hashCode = 31 * this.hashCode + (this.vlan == null ? 0 : this.vlan.hashCode());
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        if (this.ipv4Address == null ? other.ipv4Address != null : !this.ipv4Address.equals(other.ipv4Address)) {
            return false;
        }
        if (this.macAddress != other.macAddress) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals((Object)other.port)) {
            return false;
        }
        return !(this.vlan == null ? other.vlan != null : !this.vlan.equals(other.vlan));
    }

    public HostNodeConnector toHostNodeConnector() {
        try {
            NodeConnector n = this.getPort();
            InetAddress ip = InetAddress.getByAddress(NetUtils.intToByteArray4((int)this.getIpv4Address()));
            byte[] macAddr = NetUtils.longToByteArray6((long)this.getMacAddress());
            HostNodeConnector nc = new HostNodeConnector(macAddr, ip, n, 0);
            return nc;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return "Entity [macAddress=" + this.macAddress + ", ipv4Address=" + this.ipv4Address + ", vlan=" + this.vlan + ", port=" + this.port + "]";
    }

    @Override
    public int compareTo(Entity o) {
        int r;
        if (this.port == null) {
            r = o.port == null ? 0 : -1;
        } else if (o.port == null) {
            r = 1;
        } else {
            Comparable oswitchId;
            Comparable switchId = (Comparable)this.port.getNode().getID();
            r = switchId.compareTo(oswitchId = (Comparable)o.port.getNode().getID());
            if (r != 0) {
                return r;
            }
            Comparable portId = (Comparable)this.port.getID();
            Comparable oportId = (Comparable)o.port.getID();
            r = portId.compareTo(oportId);
        }
        return r;
    }
}

