package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.TestStatusOutput.ExecStatus;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>rpcbenchmark</b>
 * <br>(Source path: <i>META-INF/yang/rpcbenchmark.yang</i>):
 * <pre>
 * container output {
 *     leaf execStatus {
 *         type enumeration;
 *     }
 *     leaf global-server-cnt {
 *         type global-server-cnt;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>rpcbenchmark/test-status/output</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.TestStatusOutputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.TestStatusOutputBuilder
 *
 */
public interface TestStatusOutput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.TestStatusOutput>
{


    public enum ExecStatus {
        Idle(1),
        
        Executing(2)
        ;
    
    
        int value;
        private static final java.util.Map<java.lang.Integer, ExecStatus> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, ExecStatus> b = com.google.common.collect.ImmutableMap.builder();
            for (ExecStatus enumItem : ExecStatus.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private ExecStatus(int value) {
            this.value = value;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding ExecStatus item
         */
        public static ExecStatus forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }

    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:rpcbenchmark",
        "2015-07-02", "output").intern();

    ExecStatus getExecStatus();
    
    /**
     * The number of times the Global RPC server was invoked
     *
     */
    java.lang.Long getGlobalServerCnt();

}

