package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestInput.Operation;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>rpcbenchmark</b>
 * <br>(Source path: <i>META-INF/yang/rpcbenchmark.yang</i>):
 * <pre>
 * container input {
 *     leaf operation {
 *         type enumeration;
 *     }
 *     leaf num-clients {
 *         type num-clients;
 *     }
 *     leaf num-servers {
 *         type num-servers;
 *     }
 *     leaf payload-size {
 *         type payload-size;
 *     }
 *     leaf iterations {
 *         type iterations;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>rpcbenchmark/start-test/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestInputBuilder
 *
 */
public interface StartTestInput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestInput>
{


    public enum Operation {
        /**
         * Use Global RPC service and run-to-completion client
         *
         */
        GLOBALRTC(1),
        
        /**
         * Use routed RPC service and run-to-completion client. RPC server instances are 
         * dynamically created when the test starts and deleted when the test finishes
         *
         */
        ROUTEDRTC(2)
        ;
    
    
        int value;
        private static final java.util.Map<java.lang.Integer, Operation> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, Operation> b = com.google.common.collect.ImmutableMap.builder();
            for (Operation enumItem : Operation.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private Operation(int value) {
            this.value = value;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding Operation item
         */
        public static Operation forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }

    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:rpcbenchmark",
        "2015-07-02", "input").intern();

    /**
     * RPC type and client type to use in the test
     *
     */
    Operation getOperation();
    
    /**
     * Number of clients (test client threads) to start
     *
     */
    java.lang.Long getNumClients();
    
    /**
     * Number of RPC server instances. Only valid for routed RPCs.
     *
     */
    java.lang.Long getNumServers();
    
    /**
     * Input/Output payload size: number of elements in the list of integers that is 
     * the input and output RPC payload
     *
     */
    java.lang.Long getPayloadSize();
    
    /**
     * Number of calls to the specified RPC server that is to be made by each client
     *
     */
    java.lang.Long getIterations();

}

