package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702;
import java.util.concurrent.Future;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;


/**
 * Interface for implementing the following YANG RPCs defined in module <b>rpcbenchmark</b>
 * <br>(Source path: <i>META-INF/yang/rpcbenchmark.yang</i>):
 * <pre>
 * rpc test-status {
 *     "Get test status";
 *     output {
 *         leaf execStatus {
 *             type enumeration;
 *         }
 *         leaf global-server-cnt {
 *             type global-server-cnt;
 *         }
 *     }
 * }
 * rpc start-test {
 *     "Start a new RPC Benchmark test run";
 *     input {
 *         leaf operation {
 *             type enumeration;
 *         }
 *         leaf num-clients {
 *             type num-clients;
 *         }
 *         leaf num-servers {
 *             type num-servers;
 *         }
 *         leaf payload-size {
 *             type payload-size;
 *         }
 *         leaf iterations {
 *             type iterations;
 *         }
 *     }
 *     
 *     output {
 *         leaf global-rtc-client-ok {
 *             type global-rtc-client-ok;
 *         }
 *         leaf global-rtc-client-error {
 *             type global-rtc-client-error;
 *         }
 *         leaf exec-time {
 *             type exec-time;
 *         }
 *         leaf rate {
 *             type rate;
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface RpcbenchmarkService
    extends
    RpcService
{




    /**
     * Get test status
     *
     */
    Future<RpcResult<TestStatusOutput>> testStatus();
    
    /**
     * Start a new RPC Benchmark test run
     *
     */
    Future<RpcResult<StartTestOutput>> startTest(StartTestInput input);

}

