package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105;
import java.util.Collections;
import java.util.Objects;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput
 *
 */
public class StartTestOutputBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput> {

    private java.lang.Long _listenerElapsedTime;
    private java.lang.Long _listenerOk;
    private java.lang.Long _listenerRate;
    private java.lang.Long _producerElapsedTime;
    private java.lang.Long _producerError;
    private java.lang.Long _producerOk;
    private java.lang.Long _producerRate;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>> augmentation = Collections.emptyMap();

    public StartTestOutputBuilder() {
    }

    public StartTestOutputBuilder(StartTestOutput base) {
        this._listenerElapsedTime = base.getListenerElapsedTime();
        this._listenerOk = base.getListenerOk();
        this._listenerRate = base.getListenerRate();
        this._producerElapsedTime = base.getProducerElapsedTime();
        this._producerError = base.getProducerError();
        this._producerOk = base.getProducerOk();
        this._producerRate = base.getProducerRate();
        if (base instanceof StartTestOutputImpl) {
            StartTestOutputImpl impl = (StartTestOutputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.Long getListenerElapsedTime() {
        return _listenerElapsedTime;
    }
    
    public java.lang.Long getListenerOk() {
        return _listenerOk;
    }
    
    public java.lang.Long getListenerRate() {
        return _listenerRate;
    }
    
    public java.lang.Long getProducerElapsedTime() {
        return _producerElapsedTime;
    }
    
    public java.lang.Long getProducerError() {
        return _producerError;
    }
    
    public java.lang.Long getProducerOk() {
        return _producerOk;
    }
    
    public java.lang.Long getProducerRate() {
        return _producerRate;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
     private static void checkListenerElapsedTimeRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestOutputBuilder setListenerElapsedTime(final java.lang.Long value) {
    if (value != null) {
        checkListenerElapsedTimeRange(value);
    }
        this._listenerElapsedTime = value;
        return this;
    }
    
     
     private static void checkListenerOkRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestOutputBuilder setListenerOk(final java.lang.Long value) {
    if (value != null) {
        checkListenerOkRange(value);
    }
        this._listenerOk = value;
        return this;
    }
    
     
     private static void checkListenerRateRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestOutputBuilder setListenerRate(final java.lang.Long value) {
    if (value != null) {
        checkListenerRateRange(value);
    }
        this._listenerRate = value;
        return this;
    }
    
     
     private static void checkProducerElapsedTimeRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestOutputBuilder setProducerElapsedTime(final java.lang.Long value) {
    if (value != null) {
        checkProducerElapsedTimeRange(value);
    }
        this._producerElapsedTime = value;
        return this;
    }
    
     
     private static void checkProducerErrorRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestOutputBuilder setProducerError(final java.lang.Long value) {
    if (value != null) {
        checkProducerErrorRange(value);
    }
        this._producerError = value;
        return this;
    }
    
     
     private static void checkProducerOkRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestOutputBuilder setProducerOk(final java.lang.Long value) {
    if (value != null) {
        checkProducerOkRange(value);
    }
        this._producerOk = value;
        return this;
    }
    
     
     private static void checkProducerRateRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestOutputBuilder setProducerRate(final java.lang.Long value) {
    if (value != null) {
        checkProducerRateRange(value);
    }
        this._producerRate = value;
        return this;
    }
    
    public StartTestOutputBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public StartTestOutputBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StartTestOutput build() {
        return new StartTestOutputImpl(this);
    }

    private static final class StartTestOutputImpl implements StartTestOutput {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput.class;
        }

        private final java.lang.Long _listenerElapsedTime;
        private final java.lang.Long _listenerOk;
        private final java.lang.Long _listenerRate;
        private final java.lang.Long _producerElapsedTime;
        private final java.lang.Long _producerError;
        private final java.lang.Long _producerOk;
        private final java.lang.Long _producerRate;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>> augmentation = Collections.emptyMap();

        private StartTestOutputImpl(StartTestOutputBuilder base) {
            this._listenerElapsedTime = base.getListenerElapsedTime();
            this._listenerOk = base.getListenerOk();
            this._listenerRate = base.getListenerRate();
            this._producerElapsedTime = base.getProducerElapsedTime();
            this._producerError = base.getProducerError();
            this._producerOk = base.getProducerOk();
            this._producerRate = base.getProducerRate();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.Long getListenerElapsedTime() {
            return _listenerElapsedTime;
        }
        
        @Override
        public java.lang.Long getListenerOk() {
            return _listenerOk;
        }
        
        @Override
        public java.lang.Long getListenerRate() {
            return _listenerRate;
        }
        
        @Override
        public java.lang.Long getProducerElapsedTime() {
            return _producerElapsedTime;
        }
        
        @Override
        public java.lang.Long getProducerError() {
            return _producerError;
        }
        
        @Override
        public java.lang.Long getProducerOk() {
            return _producerOk;
        }
        
        @Override
        public java.lang.Long getProducerRate() {
            return _producerRate;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_listenerElapsedTime);
            result = prime * result + Objects.hashCode(_listenerOk);
            result = prime * result + Objects.hashCode(_listenerRate);
            result = prime * result + Objects.hashCode(_producerElapsedTime);
            result = prime * result + Objects.hashCode(_producerError);
            result = prime * result + Objects.hashCode(_producerOk);
            result = prime * result + Objects.hashCode(_producerRate);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput)obj;
            if (!Objects.equals(_listenerElapsedTime, other.getListenerElapsedTime())) {
                return false;
            }
            if (!Objects.equals(_listenerOk, other.getListenerOk())) {
                return false;
            }
            if (!Objects.equals(_listenerRate, other.getListenerRate())) {
                return false;
            }
            if (!Objects.equals(_producerElapsedTime, other.getProducerElapsedTime())) {
                return false;
            }
            if (!Objects.equals(_producerError, other.getProducerError())) {
                return false;
            }
            if (!Objects.equals(_producerOk, other.getProducerOk())) {
                return false;
            }
            if (!Objects.equals(_producerRate, other.getProducerRate())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                StartTestOutputImpl otherImpl = (StartTestOutputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("StartTestOutput [");
            boolean first = true;
        
            if (_listenerElapsedTime != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_listenerElapsedTime=");
                builder.append(_listenerElapsedTime);
             }
            if (_listenerOk != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_listenerOk=");
                builder.append(_listenerOk);
             }
            if (_listenerRate != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_listenerRate=");
                builder.append(_listenerRate);
             }
            if (_producerElapsedTime != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_producerElapsedTime=");
                builder.append(_producerElapsedTime);
             }
            if (_producerError != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_producerError=");
                builder.append(_producerError);
             }
            if (_producerOk != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_producerOk=");
                builder.append(_producerOk);
             }
            if (_producerRate != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_producerRate=");
                builder.append(_producerRate);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
