package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ntfbenchmark</b>
 * <br>(Source path: <i>META-INF/yang/ntfbenchmark.yang</i>):
 * <pre>
 * container output {
 *     leaf listener-ok {
 *         type listener-ok;
 *     }
 *     leaf producer-ok {
 *         type producer-ok;
 *     }
 *     leaf producer-error {
 *         type producer-error;
 *     }
 *     leaf producer-elapsed-time {
 *         type producer-elapsed-time;
 *     }
 *     leaf listener-elapsed-time {
 *         type listener-elapsed-time;
 *     }
 *     leaf producer-rate {
 *         type producer-rate;
 *     }
 *     leaf listener-rate {
 *         type listener-rate;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ntfbenchmark/start-test/output</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutputBuilder
 *
 */
public interface StartTestOutput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:ntfbenchmark",
        "2015-01-05", "output").intern();

    /**
     * Number of successfully creceived notifications by all listeners
     *
     */
    java.lang.Long getListenerOk();
    
    /**
     * Number of successfully generated notifications in all producer clients
     *
     */
    java.lang.Long getProducerOk();
    
    /**
     * Number of errors encoutered during notification generation at all producers
     *
     */
    java.lang.Long getProducerError();
    
    /**
     * The time it took for all producers to finish (i.e. to send their notifications),
     * in milliseconds
     *
     */
    java.lang.Long getProducerElapsedTime();
    
    /**
     * The time it took for all listeners to finish (i.e. to receive their 
     * notifications), in milliseconds
     *
     */
    java.lang.Long getListenerElapsedTime();
    
    /**
     * RPC rate (Number of RPCs/sec)
     *
     */
    java.lang.Long getProducerRate();
    
    /**
     * RPC rate (Number of RPCs/sec)
     *
     */
    java.lang.Long getListenerRate();

}

