package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestInput.ProducerType;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ntfbenchmark</b>
 * <br>(Source path: <i>META-INF/yang/ntfbenchmark.yang</i>):
 * <pre>
 * container input {
 *     leaf producer-type {
 *         type enumeration;
 *     }
 *     leaf producers {
 *         type producers;
 *     }
 *     leaf listeners {
 *         type listeners;
 *     }
 *     leaf payload-size {
 *         type payload-size;
 *     }
 *     leaf iterations {
 *         type iterations;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ntfbenchmark/start-test/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestInputBuilder
 *
 */
public interface StartTestInput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestInput>
{


    public enum ProducerType {
        /**
         * The producer waits for a free slot in RPC Broker's ring buffer
         *
         */
        BLOCKING(1),
        
        /**
         * The producer drops a notification if there is no free slot in RPC Broker's ring 
         * buffer
         *
         */
        DROPPING(2)
        ;
    
    
        int value;
        private static final java.util.Map<java.lang.Integer, ProducerType> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, ProducerType> b = com.google.common.collect.ImmutableMap.builder();
            for (ProducerType enumItem : ProducerType.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private ProducerType(int value) {
            this.value = value;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding ProducerType item
         */
        public static ProducerType forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }

    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:ntfbenchmark",
        "2015-01-05", "input").intern();

    /**
     * RPC type and client type to use in the test
     *
     */
    ProducerType getProducerType();
    
    /**
     * Number of notification producers (test client threads) to start
     *
     */
    java.lang.Long getProducers();
    
    /**
     * Number of notification listener instances
     *
     */
    java.lang.Long getListeners();
    
    /**
     * Notification payload size: number of elements in the list of integers that is 
     * the notification payload
     *
     */
    java.lang.Long getPayloadSize();
    
    /**
     * Number of notifications to generate in each client thread
     *
     */
    java.lang.Long getIterations();

}

