package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105;
import java.util.concurrent.Future;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;


/**
 * Interface for implementing the following YANG RPCs defined in module <b>ntfbenchmark</b>
 * <br>(Source path: <i>META-INF/yang/ntfbenchmark.yang</i>):
 * <pre>
 * rpc start-test {
 *     "Start a new RPC Benchmark test";
 *     input {
 *         leaf producer-type {
 *             type enumeration;
 *         }
 *         leaf producers {
 *             type producers;
 *         }
 *         leaf listeners {
 *             type listeners;
 *         }
 *         leaf payload-size {
 *             type payload-size;
 *         }
 *         leaf iterations {
 *             type iterations;
 *         }
 *     }
 *     
 *     output {
 *         leaf listener-ok {
 *             type listener-ok;
 *         }
 *         leaf producer-ok {
 *             type producer-ok;
 *         }
 *         leaf producer-error {
 *             type producer-error;
 *         }
 *         leaf producer-elapsed-time {
 *             type producer-elapsed-time;
 *         }
 *         leaf listener-elapsed-time {
 *             type listener-elapsed-time;
 *         }
 *         leaf producer-rate {
 *             type producer-rate;
 *         }
 *         leaf listener-rate {
 *             type listener-rate;
 *         }
 *     }
 * }
 * rpc test-status {
 *     "Get test status";
 *     output {
 *         leaf execStatus {
 *             type enumeration;
 *         }
 *         leaf ntf-cnt {
 *             type ntf-cnt;
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface NtfbenchmarkService
    extends
    RpcService
{




    /**
     * Start a new RPC Benchmark test
     *
     */
    Future<RpcResult<StartTestOutput>> startTest(StartTestInput input);
    
    /**
     * Get test status
     *
     */
    Future<RpcResult<TestStatusOutput>> testStatus();

}

