package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.outer.list.InnerList;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.outer.list.OuterChoice;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import java.util.List;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>dsbenchmark</b>
 * <br>(Source path: <i>META-INF/yang/dsbenchmark.yang</i>):
 * <pre>
 * list outer-list {
 *     key "id"
 *     leaf id {
 *         type int32;
 *     }
 *     choice outer-choice {
 *         case one {
 *             leaf one {
 *                 type string;
 *             }
 *         }
 *         case two-three {
 *             leaf two {
 *                 type string;
 *             }
 *             leaf three {
 *                 type string;
 *             }
 *         }
 *     }
 *     list inner-list {
 *         key "name"
 *         leaf name {
 *             type int32;
 *         }
 *         leaf value {
 *             type string;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>dsbenchmark/test-exec/outer-list</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterListBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterListBuilder
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterListKey
 *
 */
public interface OuterList
    extends
    ChildOf<TestExec>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList>,
    Identifiable<OuterListKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:dsbenchmark",
        "2015-01-05", "outer-list").intern();

    java.lang.Integer getId();
    
    OuterChoice getOuterChoice();
    
    List<InnerList> getInnerList();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     */
    OuterListKey getKey();

}

