package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput.Status;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>dsbenchmark</b>
 * <br>(Source path: <i>META-INF/yang/dsbenchmark.yang</i>):
 * <pre>
 * container output {
 *     leaf status {
 *         type enumeration;
 *     }
 *     leaf listBuildTime {
 *         type listBuildTime;
 *     }
 *     leaf execTime {
 *         type execTime;
 *     }
 *     leaf txOk {
 *         type txOk;
 *     }
 *     leaf txError {
 *         type txError;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>dsbenchmark/start-test/output</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutputBuilder
 *
 */
public interface StartTestOutput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestOutput>
{


    public enum Status {
        OK(1),
        
        FAILED(2),
        
        TESTINPROGRESS(3)
        ;
    
    
        int value;
        private static final java.util.Map<java.lang.Integer, Status> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, Status> b = com.google.common.collect.ImmutableMap.builder();
            for (Status enumItem : Status.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private Status(int value) {
            this.value = value;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding Status item
         */
        public static Status forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }

    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:dsbenchmark",
        "2015-01-05", "output").intern();

    /**
     * Indicates whether the test finished successfuly
     *
     */
    Status getStatus();
    
    /**
     * The time it took to build the list of lists
     *
     */
    java.lang.Long getListBuildTime();
    
    /**
     * The time it took to execute all transactions
     *
     */
    java.lang.Long getExecTime();
    
    /**
     * The number of successful transactions
     *
     */
    java.lang.Long getTxOk();
    
    /**
     * The number of failed transactions
     *
     */
    java.lang.Long getTxError();

}

