package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.Operation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.DataFormat;
import java.util.Collections;
import java.util.Objects;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.TransactionType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.DataStore;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput
 *
 */
public class StartTestInputBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput> {

    private DataFormat _dataFormat;
    private DataStore _dataStore;
    private java.lang.Long _innerElements;
    private Operation _operation;
    private java.lang.Long _outerElements;
    private java.lang.Long _putsPerTx;
    private TransactionType _transactionType;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> augmentation = Collections.emptyMap();

    public StartTestInputBuilder() {
    }

    public StartTestInputBuilder(StartTestInput base) {
        this._dataFormat = base.getDataFormat();
        this._dataStore = base.getDataStore();
        this._innerElements = base.getInnerElements();
        this._operation = base.getOperation();
        this._outerElements = base.getOuterElements();
        this._putsPerTx = base.getPutsPerTx();
        this._transactionType = base.getTransactionType();
        if (base instanceof StartTestInputImpl) {
            StartTestInputImpl impl = (StartTestInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public DataFormat getDataFormat() {
        return _dataFormat;
    }
    
    public DataStore getDataStore() {
        return _dataStore;
    }
    
    public java.lang.Long getInnerElements() {
        return _innerElements;
    }
    
    public Operation getOperation() {
        return _operation;
    }
    
    public java.lang.Long getOuterElements() {
        return _outerElements;
    }
    
    public java.lang.Long getPutsPerTx() {
        return _putsPerTx;
    }
    
    public TransactionType getTransactionType() {
        return _transactionType;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public StartTestInputBuilder setDataFormat(final DataFormat value) {
        this._dataFormat = value;
        return this;
    }
    
     
    public StartTestInputBuilder setDataStore(final DataStore value) {
        this._dataStore = value;
        return this;
    }
    
     
     private static void checkInnerElementsRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestInputBuilder setInnerElements(final java.lang.Long value) {
    if (value != null) {
        checkInnerElementsRange(value);
    }
        this._innerElements = value;
        return this;
    }
    
     
    public StartTestInputBuilder setOperation(final Operation value) {
        this._operation = value;
        return this;
    }
    
     
     private static void checkOuterElementsRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestInputBuilder setOuterElements(final java.lang.Long value) {
    if (value != null) {
        checkOuterElementsRange(value);
    }
        this._outerElements = value;
        return this;
    }
    
     
     private static void checkPutsPerTxRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public StartTestInputBuilder setPutsPerTx(final java.lang.Long value) {
    if (value != null) {
        checkPutsPerTxRange(value);
    }
        this._putsPerTx = value;
        return this;
    }
    
     
    public StartTestInputBuilder setTransactionType(final TransactionType value) {
        this._transactionType = value;
        return this;
    }
    
    public StartTestInputBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public StartTestInputBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StartTestInput build() {
        return new StartTestInputImpl(this);
    }

    private static final class StartTestInputImpl implements StartTestInput {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.class;
        }

        private final DataFormat _dataFormat;
        private final DataStore _dataStore;
        private final java.lang.Long _innerElements;
        private final Operation _operation;
        private final java.lang.Long _outerElements;
        private final java.lang.Long _putsPerTx;
        private final TransactionType _transactionType;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> augmentation = Collections.emptyMap();

        private StartTestInputImpl(StartTestInputBuilder base) {
            this._dataFormat = base.getDataFormat();
            this._dataStore = base.getDataStore();
            this._innerElements = base.getInnerElements();
            this._operation = base.getOperation();
            this._outerElements = base.getOuterElements();
            this._putsPerTx = base.getPutsPerTx();
            this._transactionType = base.getTransactionType();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public DataFormat getDataFormat() {
            return _dataFormat;
        }
        
        @Override
        public DataStore getDataStore() {
            return _dataStore;
        }
        
        @Override
        public java.lang.Long getInnerElements() {
            return _innerElements;
        }
        
        @Override
        public Operation getOperation() {
            return _operation;
        }
        
        @Override
        public java.lang.Long getOuterElements() {
            return _outerElements;
        }
        
        @Override
        public java.lang.Long getPutsPerTx() {
            return _putsPerTx;
        }
        
        @Override
        public TransactionType getTransactionType() {
            return _transactionType;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dataFormat);
            result = prime * result + Objects.hashCode(_dataStore);
            result = prime * result + Objects.hashCode(_innerElements);
            result = prime * result + Objects.hashCode(_operation);
            result = prime * result + Objects.hashCode(_outerElements);
            result = prime * result + Objects.hashCode(_putsPerTx);
            result = prime * result + Objects.hashCode(_transactionType);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput)obj;
            if (!Objects.equals(_dataFormat, other.getDataFormat())) {
                return false;
            }
            if (!Objects.equals(_dataStore, other.getDataStore())) {
                return false;
            }
            if (!Objects.equals(_innerElements, other.getInnerElements())) {
                return false;
            }
            if (!Objects.equals(_operation, other.getOperation())) {
                return false;
            }
            if (!Objects.equals(_outerElements, other.getOuterElements())) {
                return false;
            }
            if (!Objects.equals(_putsPerTx, other.getPutsPerTx())) {
                return false;
            }
            if (!Objects.equals(_transactionType, other.getTransactionType())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                StartTestInputImpl otherImpl = (StartTestInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("StartTestInput [");
            boolean first = true;
        
            if (_dataFormat != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dataFormat=");
                builder.append(_dataFormat);
             }
            if (_dataStore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dataStore=");
                builder.append(_dataStore);
             }
            if (_innerElements != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_innerElements=");
                builder.append(_innerElements);
             }
            if (_operation != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_operation=");
                builder.append(_operation);
             }
            if (_outerElements != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_outerElements=");
                builder.append(_outerElements);
             }
            if (_putsPerTx != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_putsPerTx=");
                builder.append(_putsPerTx);
             }
            if (_transactionType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_transactionType=");
                builder.append(_transactionType);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
