package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.Operation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.DataFormat;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.TransactionType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput.DataStore;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>dsbenchmark</b>
 * <br>(Source path: <i>META-INF/yang/dsbenchmark.yang</i>):
 * <pre>
 * container input {
 *     leaf operation {
 *         type enumeration;
 *     }
 *     leaf data-format {
 *         type enumeration;
 *     }
 *     leaf transaction-type {
 *         type enumeration;
 *     }
 *     leaf data-store {
 *         type enumeration;
 *     }
 *     leaf outerElements {
 *         type outerElements;
 *     }
 *     leaf innerElements {
 *         type innerElements;
 *     }
 *     leaf putsPerTx {
 *         type putsPerTx;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>dsbenchmark/start-test/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInputBuilder
 *
 */
public interface StartTestInput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput>
{


    public enum Operation {
        /**
         * The put operation
         *
         */
        PUT(1),
        
        /**
         * The merge operation
         *
         */
        MERGE(2),
        
        /**
         * Delete items from a list sotred in the data store
         *
         */
        DELETE(3),
        
        /**
         * The read operation
         *
         */
        READ(4)
        ;
    
    
        int value;
        private static final java.util.Map<java.lang.Integer, Operation> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, Operation> b = com.google.common.collect.ImmutableMap.builder();
            for (Operation enumItem : Operation.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private Operation(int value) {
            this.value = value;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding Operation item
         */
        public static Operation forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }
    
    public enum DataFormat {
        BINDINGAWARE(1),
        
        BINDINGINDEPENDENT(2)
        ;
    
    
        int value;
        private static final java.util.Map<java.lang.Integer, DataFormat> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, DataFormat> b = com.google.common.collect.ImmutableMap.builder();
            for (DataFormat enumItem : DataFormat.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private DataFormat(int value) {
            this.value = value;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding DataFormat item
         */
        public static DataFormat forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }
    
    public enum TransactionType {
        SIMPLETX(1),
        
        TXCHAINING(2)
        ;
    
    
        int value;
        private static final java.util.Map<java.lang.Integer, TransactionType> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, TransactionType> b = com.google.common.collect.ImmutableMap.builder();
            for (TransactionType enumItem : TransactionType.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private TransactionType(int value) {
            this.value = value;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding TransactionType item
         */
        public static TransactionType forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }
    
    public enum DataStore {
        CONFIG(1),
        
        OPERATIONAL(2),
        
        BOTH(3)
        ;
    
    
        int value;
        private static final java.util.Map<java.lang.Integer, DataStore> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, DataStore> b = com.google.common.collect.ImmutableMap.builder();
            for (DataStore enumItem : DataStore.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private DataStore(int value) {
            this.value = value;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding DataStore item
         */
        public static DataStore forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }

    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:dsbenchmark",
        "2015-01-05", "input").intern();

    /**
     * Type of the transaction operation to benchmark
     *
     */
    Operation getOperation();
    
    /**
     * Data format:-binding-aware or binding-independent
     *
     */
    DataFormat getDataFormat();
    
    /**
     * Data format:-binding-aware or binding-independent
     *
     */
    TransactionType getTransactionType();
    
    DataStore getDataStore();
    
    /**
     * Number of elements in the OuterList
     *
     */
    java.lang.Long getOuterElements();
    
    /**
     * Number of elements in the InnerList
     *
     */
    java.lang.Long getInnerElements();
    
    /**
     * Number of write operations (PUT, MERGE, or DELETE) per transaction submit
     *
     */
    java.lang.Long getPutsPerTx();

}

