package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import java.util.concurrent.Future;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;


/**
 * Interface for implementing the following YANG RPCs defined in module <b>dsbenchmark</b>
 * <br>(Source path: <i>META-INF/yang/dsbenchmark.yang</i>):
 * <pre>
 * rpc start-test {
 *     "Start a new data store write test run";
 *     input {
 *         leaf operation {
 *             type enumeration;
 *         }
 *         leaf data-format {
 *             type enumeration;
 *         }
 *         leaf transaction-type {
 *             type enumeration;
 *         }
 *         leaf data-store {
 *             type enumeration;
 *         }
 *         leaf outerElements {
 *             type outerElements;
 *         }
 *         leaf innerElements {
 *             type innerElements;
 *         }
 *         leaf putsPerTx {
 *             type putsPerTx;
 *         }
 *     }
 *     
 *     output {
 *         leaf status {
 *             type enumeration;
 *         }
 *         leaf listBuildTime {
 *             type listBuildTime;
 *         }
 *         leaf execTime {
 *             type execTime;
 *         }
 *         leaf txOk {
 *             type txOk;
 *         }
 *         leaf txError {
 *             type txError;
 *         }
 *     }
 * }
 * rpc cleanup-store {
 *     "Delete data in the test-exec container that may have been left behind from a previous test run";
 * }
 * </pre>
 *
 */
public interface DsbenchmarkService
    extends
    RpcService
{




    /**
     * Start a new data store write test run
     *
     */
    Future<RpcResult<StartTestOutput>> startTest(StartTestInput input);
    
    /**
     * Delete data in the test-exec container that may have been left behind from a 
     * previous test run
     *
     */
    Future<RpcResult<java.lang.Void>> cleanupStore();

}

