package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105;
import org.opendaylight.yangtools.yang.binding.DataRoot;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>dsbenchmark</b>
 * <br>Source path: <i>META-INF/yang/dsbenchmark.yang</i>):
 * <pre>
 * module dsbenchmark {
 *     yang-version 1;
 *     namespace "urn:opendaylight:params:xml:ns:yang:dsbenchmark";
 *     prefix "dsbenchmark";
 *
 *     revision 2015-01-05 {
 *         description "";
 *     }
 *
 *     container test-exec {
 *         list outer-list {
 *             key "id"
 *             leaf id {
 *                 type int32;
 *             }
 *             choice outer-choice {
 *                 case one {
 *                     leaf one {
 *                         type string;
 *                     }
 *                 }
 *                 case two-three {
 *                     leaf two {
 *                         type string;
 *                     }
 *                     leaf three {
 *                         type string;
 *                     }
 *                 }
 *             }
 *             list inner-list {
 *                 key "name"
 *                 leaf name {
 *                     type int32;
 *                 }
 *                 leaf value {
 *                     type string;
 *                 }
 *             }
 *         }
 *     }
 *     container test-status {
 *         leaf execStatus {
 *             type enumeration;
 *         }
 *         leaf testsCompleted {
 *             type testsCompleted;
 *         }
 *     }
 *
 *     rpc start-test {
 *         "Start a new data store write test run";
 *         input {
 *             leaf operation {
 *                 type enumeration;
 *             }
 *             leaf data-format {
 *                 type enumeration;
 *             }
 *             leaf transaction-type {
 *                 type enumeration;
 *             }
 *             leaf data-store {
 *                 type enumeration;
 *             }
 *             leaf outerElements {
 *                 type outerElements;
 *             }
 *             leaf innerElements {
 *                 type innerElements;
 *             }
 *             leaf putsPerTx {
 *                 type putsPerTx;
 *             }
 *         }
 *         
 *         output {
 *             leaf status {
 *                 type enumeration;
 *             }
 *             leaf listBuildTime {
 *                 type listBuildTime;
 *             }
 *             leaf execTime {
 *                 type execTime;
 *             }
 *             leaf txOk {
 *                 type txOk;
 *             }
 *             leaf txError {
 *                 type txError;
 *             }
 *         }
 *     }
 *     rpc cleanup-store {
 *         "Delete data in the test-exec container that may have been left behind from a previous test run";
 *     }
 * }
 * </pre>
 *
 */
public interface DsbenchmarkData
    extends
    DataRoot
{




    TestExec getTestExec();
    
    TestStatus getTestStatus();

}

