package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload;
import java.util.Collections;
import java.util.Objects;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload} instances.
 *
 * @see org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload
 *
 */
public class PayloadBuilder implements Builder <org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload> {

    private java.lang.Integer _id;
    private PayloadKey _key;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>> augmentation = Collections.emptyMap();

    public PayloadBuilder() {
    }

    public PayloadBuilder(Payload base) {
        if (base.getKey() == null) {
            this._key = new PayloadKey(
                base.getId()
            );
            this._id = base.getId();
        } else {
            this._key = base.getKey();
            this._id = _key.getId();
        }
        if (base instanceof PayloadImpl) {
            PayloadImpl impl = (PayloadImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.Integer getId() {
        return _id;
    }
    
    public PayloadKey getKey() {
        return _key;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public PayloadBuilder setId(final java.lang.Integer value) {
        this._id = value;
        return this;
    }
    
     
    public PayloadBuilder setKey(final PayloadKey value) {
        this._key = value;
        return this;
    }
    
    public PayloadBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public PayloadBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Payload build() {
        return new PayloadImpl(this);
    }

    private static final class PayloadImpl implements Payload {

        public java.lang.Class<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload.class;
        }

        private final java.lang.Integer _id;
        private final PayloadKey _key;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>> augmentation = Collections.emptyMap();

        private PayloadImpl(PayloadBuilder base) {
            if (base.getKey() == null) {
                this._key = new PayloadKey(
                    base.getId()
                );
                this._id = base.getId();
            } else {
                this._key = base.getKey();
                this._id = _key.getId();
            }
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.Integer getId() {
            return _id;
        }
        
        @Override
        public PayloadKey getKey() {
            return _key;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_id);
            result = prime * result + Objects.hashCode(_key);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload other = (org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload)obj;
            if (!Objects.equals(_id, other.getId())) {
                return false;
            }
            if (!Objects.equals(_key, other.getKey())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                PayloadImpl otherImpl = (PayloadImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Payload [");
            boolean first = true;
        
            if (_id != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_id=");
                builder.append(_id);
             }
            if (_key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(_key);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
