package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload;
import java.util.Collections;
import java.util.Objects;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput} instances.
 *
 * @see org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput
 *
 */
public class RoutedRpcBenchOutputBuilder implements Builder <org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput> {

    private List<Payload> _payload;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>> augmentation = Collections.emptyMap();

    public RoutedRpcBenchOutputBuilder() {
    }
    public RoutedRpcBenchOutputBuilder(org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.Payload arg) {
        this._payload = arg.getPayload();
    }

    public RoutedRpcBenchOutputBuilder(RoutedRpcBenchOutput base) {
        this._payload = base.getPayload();
        if (base instanceof RoutedRpcBenchOutputImpl) {
            RoutedRpcBenchOutputImpl impl = (RoutedRpcBenchOutputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.Payload</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.Payload) {
            this._payload = ((org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.Payload)arg).getPayload();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.Payload] \n" +
              "but was: " + arg
            );
        }
    }

    public List<Payload> getPayload() {
        return _payload;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public RoutedRpcBenchOutputBuilder setPayload(final List<Payload> value) {
        this._payload = value;
        return this;
    }
    
    public RoutedRpcBenchOutputBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public RoutedRpcBenchOutputBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RoutedRpcBenchOutput build() {
        return new RoutedRpcBenchOutputImpl(this);
    }

    private static final class RoutedRpcBenchOutputImpl implements RoutedRpcBenchOutput {

        public java.lang.Class<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput.class;
        }

        private final List<Payload> _payload;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>> augmentation = Collections.emptyMap();

        private RoutedRpcBenchOutputImpl(RoutedRpcBenchOutputBuilder base) {
            this._payload = base.getPayload();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public List<Payload> getPayload() {
            return _payload;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_payload);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput other = (org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput)obj;
            if (!Objects.equals(_payload, other.getPayload())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RoutedRpcBenchOutputImpl otherImpl = (RoutedRpcBenchOutputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("RoutedRpcBenchOutput [");
            boolean first = true;
        
            if (_payload != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_payload=");
                builder.append(_payload);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
