package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702;
import org.opendaylight.yangtools.yang.binding.annotations.RoutingContext;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>rpcbench-payload</b>
 * <br>(Source path: <i>META-INF/yang/rpcbench-payload.yang</i>):
 * <pre>
 * container input {
 *     leaf node {
 *         type instance-identifier;
 *     }
 *     list payload {
 *         key "id"
 *         leaf id {
 *             type int32;
 *         }
 *     }
 *     uses payload;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>rpcbench-payload/routed-rpc-bench/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInputBuilder
 *
 */
public interface RoutedRpcBenchInput
    extends
    Payload,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("rpcbench-payload",
        "2015-07-02", "input").intern();

    @RoutingContext
    (
    value=org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.NodeContext.class
    )
    InstanceIdentifier<?> getNode();

}

